#ifndef MARS_MHillasExt
#define MARS_MHillasExt

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TArrayF;

class MHillas;
class MGeomCam;
class MCerPhotEvt;

class MHillasExt : public MParContainer
{
private:
    // for description see MExtHillas.cc
    Float_t fAsym;    // [mm] fDist minus dist: center of ellipse, highest pixel
    Float_t fM3Long;  // [mm] 3rd moment (e-weighted) along major axis
    Float_t fM3Trans; // [mm] 3rd moment (e-weighted) along minor axis

public:
    MHillasExt(const char *name=NULL, const char *title=NULL);

    void Reset();

    Float_t GetAsym() const    { return fAsym; }
    Float_t GetM3Long() const  { return fM3Long; }
    Float_t GetM3Trans() const { return fM3Trans; }

    Int_t Calc(const MGeomCam &geom, const MCerPhotEvt &pix, const MHillas &hil);

    void Print(Option_t *opt=NULL) const;
    void Print(const MGeomCam &geom) const;

    void Set(const TArrayF &arr);

    ClassDef(MHillasExt, 2) // Storage Container for extended Hillas Parameter
};
#endif
