#ifndef MARS_MJPedestal
#define MARS_MJPedestal

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class TCanvas;
class MParList;
class MRunIter;
class MHCamera;
class MExtractor;
class MJPedestal : public MParContainer  
{
private:

  TString fOutputPath;
  
  MRunIter   *fRuns;
  MExtractor *fExtractor;                         // Signal extractor, used to find the nr. of used FADC slices

  MPedestalCam  fPedestalCam;
  MBadPixelsCam fBadPixels;
  
  Bool_t fDataCheck;                              // Flag if the data check is run on raw data
  
  Bool_t ReadPedestalCam();
  Bool_t WriteResult();
  
  void   DisplayResult(MParList &plist);
  
public:

  MJPedestal(const char *name=NULL, const char *title=NULL);

  MPedestalCam &GetPedestalCam()            { return fPedestalCam; }
  const MBadPixelsCam &GetBadPixels() const { return fBadPixels;   }
  
  const char* GetOutputFile() const;
  
  Bool_t Process();
  Bool_t ProcessFile();
  
  void SetBadPixels ( const MBadPixelsCam &bad) { bad.Copy(fBadPixels); }
  void SetDataCheck ( const Bool_t b=kTRUE    ) { fDataCheck = b;       }
  void SetExtractor (       MExtractor* ext   ) { fExtractor = ext;     }
  void SetInput     (       MRunIter *iter    ) { fRuns      = iter;    }
  void SetOutputPath( const char *path="."    );
  
  ClassDef(MJPedestal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
