#ifndef MARS_MSequence
#define MARS_MSequence

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef ROOT_TExMap
#include <TExMap.h>
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MDirIter;

class MSequence : public MParContainer
{
public:
    enum LightCondition_t { kNA, kNoMoon, kTwilight, kMoon, kDay };
    enum FileType_t {
        kRawDat, kRawPed, kRawCal, kRawAll,
        kRootDat, kRootPed, kRootCal, kRootAll,
        kCalibrated, kImages
    };
private:
    TString fFileName;
    TString fDataPath;

    UInt_t fSequence;

    MTime  fStart;

    UInt_t fLastRun;
    UInt_t fNumEvents;

    UInt_t fPeriod;
    MTime  fNight;

    LightCondition_t fLightCondition;

    TString fProject;
    TString fSource;
    TString fTriggerTable;
    TString fHvSettings;
    TString fComment;

    TArrayI fRuns;
    TArrayI fCalRuns;
    TArrayI fPedRuns;
    TArrayI fDatRuns;

    Bool_t fMonteCarlo;

    //TExMap fFileNames;

    void Split(TString &runs, TArrayI &data) const;
    //void GetFileNames(TEnv &env, const TArrayI &arr);
    LightCondition_t ReadLightCondition(TEnv &env) const;

    const char *GetFileName(UInt_t num);

    //UInt_t SetupRuns(MDirIter &iter, const TArrayI &arr, const char *path, char *id, Bool_t raw=kFALSE) const;
    UInt_t SetupRuns(MDirIter &iter, const TArrayI &arr, FileType_t type, const char *path=0) const;
    UInt_t AddRuns(UInt_t first, UInt_t last, TArrayI *runs);

public:
    MSequence() : fSequence((UInt_t)-1), fLastRun((UInt_t)-1),
        fNumEvents((UInt_t)-1), fPeriod((UInt_t)-1), fMonteCarlo(kFALSE) { }
    MSequence(const char *fname, const char *path="");
    MSequence(const MSequence &s) : fSequence(s.fSequence), fStart(s.fStart),
        fLastRun(s.fLastRun), fNumEvents(s.fNumEvents), fPeriod(s.fPeriod),
        fNight(s.fNight), fProject(s.fProject), fSource(s.fSource),
        fTriggerTable(s.fTriggerTable), fHvSettings(s.fHvSettings),
        fRuns(s.fRuns), fCalRuns(s.fCalRuns), fPedRuns(s.fPedRuns),
        fDatRuns(s.fDatRuns), fMonteCarlo(s.fMonteCarlo) { }
    ~MSequence();

    // TObject
    void Print(Option_t *o) const;
    void Print() const { Print(); } //*MENU*

    const char *GetName() const;
    const char *GetRcName() const { return fName; }

    // Genaral interface
    Bool_t IsValid() const { return fSequence!=(UInt_t)-1; }
    Bool_t IsMonteCarlo() const { return fMonteCarlo; }

    void SetMonteCarlo(Bool_t ismc=kTRUE) { fMonteCarlo=ismc; }

    UInt_t SetupPedRuns(MDirIter &iter, const char *path=0, Bool_t raw=kFALSE) const;
    UInt_t SetupDatRuns(MDirIter &iter, const char *path=0, Bool_t raw=kFALSE) const;
    UInt_t SetupAllRuns(MDirIter &iter, const char *path=0, Bool_t raw=kFALSE) const;
    UInt_t SetupCalRuns(MDirIter &iter, const char *path=0, Bool_t raw=kFALSE) const;
    UInt_t SetupDatRuns(MDirIter &iter, FileType_t type, const char *path=0) const;
 /*
    UInt_t SetupPedRuns(MDirIter &iter, FileType_t type, const char *path=0);
    UInt_t SetupDatRuns(MDirIter &iter, FileType_t type, const char *path=0);
    UInt_t SetupAllRuns(MDirIter &iter, FileType_t type, const char *path=0);
    UInt_t SetupCalRuns(MDirIter &iter, FileType_t type, const char *path=0);
   */
    // Getter
    UInt_t GetNumAllRuns() const { return fRuns.GetSize(); }
    UInt_t GetNumDatRuns() const { return fDatRuns.GetSize(); }
    UInt_t GetNumPedRuns() const { return fPedRuns.GetSize(); }
    UInt_t GetNumCalRuns() const { return fCalRuns.GetSize(); }

    UInt_t GetSequence() const { return fSequence; }
    UInt_t GetLastRun() const  { return fLastRun; }
    UInt_t GetPeriod() const   { return fPeriod; }
    LightCondition_t GetLightCondition() const { return fLightCondition; }
    Bool_t HasMoon() const { return fLightCondition==kMoon; }

    const UInt_t GetFirstRun() const { return fRuns[0]; }
    const UInt_t GetFirstCalRun() const { return fCalRuns[0]; }
    const UInt_t GetLastCalRun() const { return fCalRuns[fCalRuns.GetSize()-1]; }
    const TArrayI &GetPedRuns() const { return fPedRuns; } 
    const TArrayI &GetCalRuns() const { return fCalRuns; } 
    const TArrayI &GetDatRuns() const { return fDatRuns; } 

    const MTime &GetStart() const { return fStart; }
    const MTime &GetNight() const { return fNight; }
    const TString &GetSource() const { return fSource; } 

    const TString GetStandardPath() const { return fMonteCarlo?"/magic/montecarlo/":"/magic/data/"; }

    const TString &GetFileName() const { return fFileName; }
    const TString &GetDataPath() const { return fDataPath; }

    // Setter
    void SetNight(const char*night);

    UInt_t AddRuns(UInt_t first, UInt_t last)    { return MSequence::AddRuns(first, last, 0); }
    UInt_t AddCalRuns(UInt_t first, UInt_t last) { return MSequence::AddRuns(first, last, &fCalRuns); }
    UInt_t AddPedRuns(UInt_t first, UInt_t last) { return MSequence::AddRuns(first, last, &fPedRuns); }
    UInt_t AddDatRuns(UInt_t first, UInt_t last) { return MSequence::AddRuns(first, last, &fDatRuns); }

    UInt_t AddRuns(UInt_t num)    { return AddRuns(num, num); }
    UInt_t AddCalRuns(UInt_t num) { return AddCalRuns(num, num); }
    UInt_t AddPedRuns(UInt_t num) { return AddPedRuns(num, num); }
    UInt_t AddDatRuns(UInt_t num) { return AddDatRuns(num, num); }

    static Bool_t InflatePath(TString &seq, Bool_t ismc=kFALSE);

    ClassDef(MSequence, 3)
};

#endif
