#ifndef MARS_MJTrainRanForest
#define MARS_MJTrainRanForest

#ifndef MARS_MJob
#include "MJob.h"
#endif

class MFilter;

class MJTrainRanForest : public MJob
{
protected:
    Bool_t fDebug;

    TList fRules;

    TList fPreCuts;
    TList fTrainCuts;
    TList fTestCuts;

    UShort_t fNumTrees;
    UShort_t fNdSize;
    UShort_t fNumTry;

    Bool_t WriteDisplay(const char *fname) const;

    void AddCut(TList &l, const char *rule);
    void AddCut(TList &l, MFilter *f);

public:
    MJTrainRanForest() : fDebug(kFALSE)
    {
        fNumTrees = 100; //100
        fNumTry   = 0;   //3   0 means: in MRanForest estimated best value will be calculated
        fNdSize   = 1;   //1
    }

    void SetDebug(Bool_t b=kTRUE) { fDebug = b; }

    void AddPreCut(const char *rule)   { AddCut(fPreCuts, rule); }
    void AddPreCut(MFilter *f)         { AddCut(fPreCuts, f); }

    void AddTrainCut(const char *rule) { AddCut(fTrainCuts, rule); }
    void AddTrainCut(MFilter *f)       { AddCut(fTrainCuts, f); }

    void AddTestCut(const char *rule)  { AddCut(fTestCuts, rule); }
    void AddTestCut(MFilter *f)        { AddCut(fTestCuts, f); }

    void SetNumTrees(UShort_t n=100) { fNumTrees = n; }
    void SetNdSize(UShort_t n=5)     { fNdSize   = n; }
    void SetNumTry(UShort_t n=0)     { fNumTry   = n; }

    Int_t AddParameter(const char *rule);

    ClassDef(MJTrainRanForest, 0)//Base class for Random Forest training classes
};

#endif
