/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 4/2003 <mailto:tbretz@astro-uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MStatusDisplay
//
//  upon an idea of Robert Wagner
//
/////////////////////////////////////////////////////////////////////////////
#include "MStatusDisplay.h"

#include <iostream.h>

#include <TCanvas.h>        // TCanvas
#include <TSystem.h>        // gSystem

#include <TGTab.h>          // TGTab
#include <TGLabel.h>        // TGLabel
#include <TGButton.h>       // TGPictureButton
#include <TGProgressBar.h>  // TGHProgressBar

#include <TRootEmbeddedCanvas.h>  // TRootEmbeddedCanvas

#include "MGList.h"

ClassImp(MStatusDisplay);

void MStatusDisplay::AddProgressBar()
{
    TGLayoutHints *laybar=new TGLayoutHints(kLHintsExpandX, 10,10,10,10);
    fList->Add(laybar);

    fBar=new TGHProgressBar(this);
    fBar->ShowPosition();
    AddFrame(fBar, laybar);
    fList->Add(fBar);
}

enum {
    kPicMagic,
    kPicMars
};

void MStatusDisplay::AddTabs()
{
    fTab = new TGTab(this, 300, 300);

    //
    // Create Tab1
    //
    TGCompositeFrame *f = fTab->AddTab("-=MARS=-");

    /*
    TGHorizontalFrame *hf = new TGHorizontalFrame(f, 1, 1);

    TGLayoutHints *lay = new TGLayoutHints(kLHintsNormal|kLHintsExpandX|kLHintsExpandY, 10., 10., 10., 10.);
    fList->Add(lay);
    f->AddFrame(hf, lay);

    const TGPicture *pic1 = fList->GetPicture("magiclogo.xpm");
    if (pic1)
    {
        TGPictureButton *magic = new TGPictureButton(hf, pic1, kPicMagic);
        fList->Add(magic);
        magic->Associate(this);

        TGLayoutHints *lay1 = new TGLayoutHints(kLHintsLeft|kLHintsTop,  10., 10., 20., 10.);
        fList->Add(lay1);
        hf->AddFrame(magic, lay1);
    }
    */
    const TGPicture *pic2 = fList->GetPicture("marslogo.xpm");
    if (pic2)
    {
        TGPictureButton *mars  = new TGPictureButton(f, pic2, kPicMars);
        fList->Add(mars);
        mars->Associate(this);

        TGLayoutHints *lay2 = new TGLayoutHints(kLHintsCenterX|kLHintsCenterY, 10., 10., 10., 10.);
        fList->Add(lay2);
        f->AddFrame(mars, lay2);
    }

    //
    // Crete second gui elemet for tab1 (TGVertical Frame)
    //
    TGLayoutHints *laytabs = new TGLayoutHints(kLHintsNormal|kLHintsExpandX|kLHintsExpandY, 10, 10, 10, 10);
    AddFrame(fTab, laytabs);

    fList->Add(fTab);
    fList->Add(laytabs);
}

void MStatusDisplay::AddStatusLine1()
{
    TGCompositeFrame *f = new TGCompositeFrame(this, 1, 1, kSunkenFrame);

    fLine1 = new TGLabel(f, "");

    TGLayoutHints *lay = new TGLayoutHints(kLHintsNormal|kLHintsExpandX, 5, 5, 2, 2);
    f->AddFrame(fLine1, lay);
    AddFrame(f, lay);

    fList->Add(f);
    fList->Add(fLine1);
    fList->Add(lay);
}

void MStatusDisplay::AddStatusLine2()
{
    TGCompositeFrame *f = new TGCompositeFrame(this, 1, 1, kSunkenFrame);

    fLine2 = new TGLabel(f, "");

    TGLayoutHints *lay = new TGLayoutHints(kLHintsNormal|kLHintsExpandX, 5, 5, 2, 2);
    f->AddFrame(fLine2, lay);
    AddFrame(f, lay);

    fList->Add(f);
    fList->Add(fLine2);
    fList->Add(lay);
}

void MStatusDisplay::SetStatusLine1(const char *txt)
{
    fLine1->SetText(txt);
}

void MStatusDisplay::SetStatusLine2(const char *txt)
{
    fLine2->SetText(txt);
}

// --------------------------------------------------------------------------
//
// Default constructor. Opens a window with a progress bar. Get a pointer
// to the bar by calling GetBar. This pointer can be used for the
// eventloop.
//
// Be carefull: killing or closing the window while the progress meter
//   is still in use may cause segmentation faults. Please kill the window
//   always by deleting the corresponding object.
//
MStatusDisplay::MStatusDisplay() : TGTransientFrame(gClient->GetRoot(), gClient->GetRoot(), 1, 1)
{
    fList = new MGList;
    fList->SetOwner();

    SetWMSizeHints(640, 480, 1280, 1024, 10, 10); // set the smallest and biggest size of the Main frame
    Move(rand()%100+50, rand()%100+50);

    fLayCanvas = new TGLayoutHints(kLHintsExpandX|kLHintsExpandY, 3, 3, 3, 3);
    fList->Add(fLayCanvas);

    AddTabs();
    AddProgressBar();
    AddStatusLine1();
    AddStatusLine2();

    MapSubwindows();

    Layout();

    SetWindowName("Status Display");
    SetIconName("Status Display");

    MapWindow();
}

// --------------------------------------------------------------------------
//
// Destruct the window with all its tiles. Also the Progress Bar object
// is deleted.
//
MStatusDisplay::~MStatusDisplay()
{
    delete fList;
} 

TCanvas *MStatusDisplay::GetCanvas(TGCompositeFrame *cf)
{
    TIter Next(cf->GetList());

    TGFrameElement *f;
    while ((f=(TGFrameElement*)Next()))
        if (f->fFrame->InheritsFrom(TRootEmbeddedCanvas::Class()))
            return ((TRootEmbeddedCanvas*)f->fFrame)->GetCanvas();

    return NULL;
}

TCanvas *MStatusDisplay::GetCanvas(int i)
{
    if (i<0 || i>=fTab->GetNumberOfTabs())
    {
        cout << "MStatusDisplay::GetCanvas: Out of range." << endl;
        return NULL;
    }

    return GetCanvas(fTab->GetTabContainer(i));
}

TCanvas *MStatusDisplay::GetCanvas(const TString &name)
{
    TGFrameElement *f;
    TIter Next(fTab->GetList());
    while ((f=(TGFrameElement*)Next()))
    {
        TObject *frame = f->fFrame;
        if (!frame->InheritsFrom(TGTabElement::Class()))
            continue;

        TGTabElement *tab = (TGTabElement*)frame;
        if (tab->GetString()==name)
            break;
    }

    // Search for the next TGCompositeFrame in the list
    while ((f=(TGFrameElement*)Next()))
    {
        TObject *frame = f->fFrame;
        if (frame->InheritsFrom(TGCompositeFrame::Class()))
            return GetCanvas((TGCompositeFrame*)frame);
    }

    return NULL;
}

TCanvas &MStatusDisplay::AddTab(const char *name)
{
    TGCompositeFrame *f = fTab->AddTab(name);

    TRootEmbeddedCanvas *ec = new TRootEmbeddedCanvas(name, f, 100, 100, 0);
    f->AddFrame(ec, fLayCanvas);
    fList->Add(ec);

    TCanvas &c = *ec->GetCanvas();

    c.SetFillColor(/*165*/17);
    c.SetBorderMode(0);

    MapSubwindows();
    Layout();
    // MapWindow();

    cout << "Adding Tab '" << name << "' (TCanvas=" << &c << ")" <<  ec << endl;

    return c;
}

Bool_t MStatusDisplay::ProcessMessage(Long_t msg, Long_t mp1, Long_t mp2)
{
    cout << "Msg: " << GET_MSG(msg) << " Submsg:" << GET_SUBMSG(msg) << " Mp1=";
    cout << mp1 << " Mp2=" << mp2 << endl;

    return kTRUE;
}

void MStatusDisplay::CloseWindow()
{
    // Got close message for this MainFrame. Calls parent CloseWindow()
    // (which destroys the window) and terminate the application.
    // The close message is generated by the window manager when its close
    // window menu item is selected.

    // CloseWindow must be overwritten because otherwise CloseWindow
    // and the destructor are calling DestroyWindow which seems to be
    // in conflict with the TRootEmbeddedCanvas.
    delete this;
}

