#include "MDataCheck.h"

#include <TGButton.h>  // TGTextButton

ClassImp(MDataCheck)

enum {
  M_BUTTON_PEDADC,
  M_BUTTON_CRADC,
  M_BUTTON_PEDTDC,
  M_BUTTON_CRTDC
};

MDataCheck::MDataCheck(const TGWindow *main, const TGWindow *p,
                                 const UInt_t w, const UInt_t h)
: MBrowser(main, p, w, h)
{

    fButPedADC = new TGTextButton(fTop2, "ADC Spectra of Pedestals", M_BUTTON_PEDADC );
    fButPedADC->Associate(this) ;
    fTop2->AddFrame (fButPedADC, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

    fButCrADC = new TGTextButton(fTop2, "ADC Specta of Cosmics", M_BUTTON_CRADC );
    fButCrADC->Associate(this) ;
    fTop2->AddFrame (fButCrADC, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

    fButPedTDC = new TGTextButton(fTop3, "TDC Spectra of Pedestals", M_BUTTON_PEDTDC );
    fButPedTDC->Associate(this) ;
    fTop3->AddFrame (fButPedTDC, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

    fButCrTDC = new TGTextButton(fTop3, "TDC Specta of Cosmics", M_BUTTON_CRTDC );
    fButCrTDC->Associate(this) ;
    fTop3->AddFrame (fButCrTDC, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

    MapSubwindows();

    Layout();

    SetWindowName("DataCheck Window");
    SetIconName("DataCheck");

    MapWindow();
}

MDataCheck::~MDataCheck()
{
    delete fButPedADC;
    delete fButCrADC;
    delete fButPedTDC;
    delete fButCrTDC;
} 

// ======================================================================

Bool_t MDataCheck::ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2)
{     
  // Process events generated by the buttons in the frame.
  
    if (GET_MSG(msg)!=kC_COMMAND || GET_SUBMSG(msg)!=kCM_BUTTON)
        return MBrowser::ProcessMessage(msg, parm1, parm2);

    switch (parm1)
    {
    case M_BUTTON_PEDADC:
    case M_BUTTON_CRADC:
    case M_BUTTON_PEDTDC:
    case M_BUTTON_CRTDC:
        if (!InputFileSelected())
        {     
            DisplError("No Input (root) File selected!");
            return kTRUE;
        }

        switch (parm1)
        {
        case M_BUTTON_PEDADC:
            fViewAdc.AdcSpectra(fInputFile, "PedEvents" ) ;
            return kTRUE;

        case M_BUTTON_CRADC:
            fViewAdc.AdcSpectra(fInputFile, "Events" ) ;
            return kTRUE;

        case M_BUTTON_PEDTDC:
            // fOctober.PedTdcSpectra(fInputFile) ;
            return kTRUE;

        case M_BUTTON_CRTDC:
            return kTRUE;
        }
        return kTRUE;
    }

    return MBrowser::ProcessMessage(msg, parm1, parm2);
} 
