#ifndef MBROWSER_H
#define MBROWSER_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class TGMenuBar;
class TGPopupMenu;
class TGTab;
class TGComboBox;
class TGTextButton;
class TGListBox;
class TGPictureButton;
class TGFileContainer;
class TGListView;

class MBrowser : public TGTransientFrame
{
private:

    //
    // Create a main frame with a number of different buttons.
    //

    //   some member not connected with Gui

    //  the things for the menu bar

    TGMenuBar         *fMenuBar ;
    TGPopupMenu       *fFileMenu ;

    //
    //   divide the Window in two different parts
    //
    TGCompositeFrame  *fFrameTop;   // top part of the main window
    TGCompositeFrame  *fFrameLow;   // low part of the main window
    TGTab             *fTab;        // different tabs in the low window

    //
    //   the things in the file selector
    //
    TGCompositeFrame  *fTabF1;     // first tab of low part
    TGCompositeFrame  *fTabF1a;    // subpart of the file selector in low window
    TGCompositeFrame  *fTabF1b;    // subpart of the file selector in low window
    TGComboBox        *fDir;
    TGPictureButton   *fCdup;
    TGPictureButton   *fListMode;
    TGPictureButton   *fDetail;
    TGFileContainer   *fFileCont;
    TGListView        *fFileView;

    //     Layout hints for different uses

    TGLayoutHints     *fLayMenuBar;
    TGLayoutHints     *fLayMenuItem;
    TGLayoutHints     *fLayTab;

    //     some icons and pictures often used

    const TGPicture   *fPicCdup;
    const TGPicture   *fPicList;
    const TGPicture   *fPicDetail;

protected:
    Char_t fInputFile[256];

    void DisplError(const char *txt);
    void DisplWarning(const char *txt);
    void DisplInfo(const char *txt);

    void ChangeDir(const char *txt=NULL);

    TGHorizontalFrame *fTop1;
    TGHorizontalFrame *fTop2;
    TGHorizontalFrame *fTop3;

 public: 
     MBrowser(const TGWindow *main=NULL, const TGWindow *p=NULL,
               const UInt_t w=500, const UInt_t h=500) ;

     ~MBrowser();

     void   CloseWindow();

     Bool_t InputFileSelected();

     virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

     ClassDef(MBrowser, 0)   // Base class for the gui
} ; 

#endif


