#ifndef MMCENERHISTO_H
#define MMCENERHISTO_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

#ifndef TH1_H
#include <TH1.h>
#endif
#ifndef TF1_H
#include <TF1.h>
#endif

class TH1F;
class TF1;

class MMcEnerHisto : public TObject { 

 private: 

  TH1F* hLogEner; // histogram with the logarith of the energy
  TF1* fLogEner;  // gausian function to fit the histogram

 public: 
  
  MMcEnerHisto(const int index) ;
  ~MMcEnerHisto() ; 

  Float_t GetEnerThre() ;
  Float_t GetEnerThreErr() ;
  Float_t GetPeakAtLogE() ;
  Float_t GetSigmaAtLogE() ;

  void SetBins(Int_t nbins = 100, Float_t xmin = 0.5, Float_t xmax = 4.5) ;

  void Fill(Float_t log10E, Float_t w) ;
  void Fit(const char *fname, Option_t *option, Option_t *goption, Axis_t xxmin, Axis_t xxmax) ;  
  void Draw(Option_t* option = "") ; 
  void Print() ;  

  ClassDef(MMcEnerHisto, 1)  //  Data Container to calculate Energy Threshold
} ; 

#endif 
