/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!              Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MMcCollectionAreaCalc.h"

#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MMcEvt.hxx"
#include "MMcTrig.hxx" 

#include "MHMcCollectionArea.h"

ClassImp(MMcCollectionAreaCalc)

MMcCollectionAreaCalc::MMcCollectionAreaCalc (const char *name, const char *title)
{
    *fName  = name  ? name  : "MMcCollectionAreaCalc";
    *fTitle = title ? title : "Task to calc the collection area ";
} 

Bool_t MMcCollectionAreaCalc::PreProcess (MParList *pList)
{
    // connect the raw data with this task

    fMcEvt = (MMcEvt*)pList->FindObject("MMcEvt");
    if (!fMcEvt)
    {
        *fLog << dbginf << "MMcEvt not found... exit." << endl;
        return kFALSE;
    }

    fMcTrig = (MMcTrig*)pList->FindObject("MMcTrig");
    if (!fMcTrig)
    {
        *fLog << dbginf << "MMcTrig not found... exit." << endl;
        return kFALSE;
    }

    fCollArea = (MHMcCollectionArea*)pList->FindCreateObj("MHMcCollectionArea");
    if (!fCollArea)
        return kFALSE;

    return kTRUE;
}

Bool_t MMcCollectionAreaCalc::Process () 
{ 
    const Float_t energy = log10(fMcEvt->GetEnergy());
    const Float_t impact = fMcEvt->GetImpact()/100.;

    fCollArea->FillAll(energy, impact);

    if (fMcTrig->GetFirstLevel() <= 0)
        return kTRUE;

    fCollArea->FillSel(energy, impact);

    return kTRUE;
}

Bool_t MMcCollectionAreaCalc::PostProcess () 
{ 
    //
    //   do the calculation of the effectiv area
    //
    fCollArea->CalcEfficiency();

    return kTRUE;
}
