#ifndef MARS_MMuonSearchPar
#define MARS_MMuonSearchPar

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MHillas;
class MGeomCam;
class MCerPhotEvt;

class MMuonSearchPar : public MParContainer
{
private:
    Float_t fRad;    // An estimated radius of the muon ring [mm]
    Float_t fDev;    // The standard deviation from the estimated ring [mm]
    Float_t fCenX;   // An estimated center position in X of the muon ring [mm]
    Float_t fCenY;   // An estimated center position in Y of the muon ring [mm]
    Bool_t  fNoMuon; // if the radius is estimated above 600 mm (2 deg.), assumed it's not muon.

public:
    MMuonSearchPar(const char *name=NULL, const char *title=NULL);

    void Reset();

    Float_t GetRad() const    { return fRad; }
    Float_t GetDev() const    { return fDev; }
    Float_t GetCenX() const   { return fCenX; }
    Float_t GetCenY() const   { return fCenY; }
    Bool_t  IsNoMuon() const  { return fNoMuon; }

    void   Print(Option_t *opt=NULL) const;
    void   Print(const MGeomCam &geom, Option_t *opt=NULL) const;
    void   CalcTempCenter(const MHillas &hillas, Float_t *xtmp1, 
			 Float_t *ytmp1, Float_t *xtmp2, Float_t *ytmp2);
    Bool_t CalcRadius(const MGeomCam &geom, const MCerPhotEvt &evt, Float_t x,
		      Float_t y, Float_t *r, Float_t *sigma);
    void   CalcMinimumDev(const MGeomCam &geom, const MCerPhotEvt &evt, 
			 Float_t x, Float_t y, Float_t xcog, 
			 Float_t ycog, Float_t sigma, Float_t *opt_rad, 
			 Float_t *new_sigma, Float_t *newx, Float_t *newy);
    void   Calc(const MGeomCam &geom, const MCerPhotEvt &evt,
	       const MHillas &hillas);

    ClassDef(MMuonSearchPar, 1) // Container to hold muon search parameters
};

#endif
