#ifndef MARS_MMuonSearchPar
#define MARS_MMuonSearchPar

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MHillas;
class MGeomCam;
class MCerPhotEvt;

class MMuonSearchPar : public MParContainer
{
private:
    Float_t fRadius;    // An estimated radius of the muon ring [mm]
    Float_t fDeviation; // The standard deviation from the estimated ring [mm]
    Float_t fCenterX;   // An estimated center position in X of the muon ring [mm]
    Float_t fCenterY;   // An estimated center position in Y of the muon ring [mm]
    Bool_t  fNoMuon;    // if the radius is estimated above 600 mm (2 deg.), assumed it's not muon. Later on, at the stage of MMuonCalibParCalc, this flag will be changed if the task judge the event as no muon.

public:
    MMuonSearchPar(const char *name=NULL, const char *title=NULL);

    void Reset();

    Float_t GetRadius()    const { return fRadius; }
    Float_t GetDeviation() const { return fDeviation; }
    Float_t GetCenterX()   const { return fCenterX; }
    Float_t GetCenterY()   const { return fCenterY; }
    Bool_t  IsNoMuon()     const { return fNoMuon; }
    void    SetNoMuon()          { fNoMuon = kTRUE; }

    void   CalcTempCenter(const MHillas &hillas, Float_t &xtmp1, 
			  Float_t &ytmp1, Float_t &xtmp2, Float_t &ytmp2);
    Bool_t CalcRadius(const MGeomCam &geom, const MCerPhotEvt &evt, Float_t x,
		      Float_t y, Float_t &r, Float_t &sigma);
    void   CalcMinimumDeviation(const MGeomCam &geom, const MCerPhotEvt &evt, 
			     Float_t x, Float_t y, Float_t xcog, 
			     Float_t ycog, Float_t sigma, Float_t &opt_rad, 
			     Float_t &new_sigma, Float_t &newx, Float_t &newy);
    void   Calc(const MGeomCam &geom, const MCerPhotEvt &evt,
		const MHillas &hillas);

    void   Print(Option_t *opt=NULL) const;
    void   Print(const MGeomCam &geom, Option_t *opt=NULL) const;

    ClassDef(MMuonSearchPar, 1) // Container to hold muon search parameters
};

#endif
