#ifndef MARS_MPedCalcFromLoGain
#define MARS_MPedCalcFromLoGain

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MGeomCam;
class MBadPixelsCam;
class MPedCalcFromLoGain : public MExtractor
{

  static const Byte_t fgHiGainFirst;      // First FADC slice Hi-Gain (currently set to: 3) 
  static const Byte_t fgHiGainLast;       // Last FADC slice Hi-Gain (currently set to: 14) 
  static const Byte_t fgLoGainFirst;      // First FADC slice Lo-Gain (currently set to: 3) 
  static const Byte_t fgLoGainLast;       // Last FADC slice Lo-Gain (currently set to: 14) 
  static const Byte_t fgHiGainWindowSize; // The extraction window Hi-Gain
  static const Byte_t fgLoGainWindowSize; // The extraction window Lo-Gain
  static const Byte_t fgMaxHiGainVar;     // The maximum difference between the highest and lowest slice 
                                          // in the high gain window allowed in order to use low gain 
                                          // for pedestal calculation
  Int_t   fNumEventsDump; // Number of event after which MPedestalCam gets updated

  Byte_t  fMaxHiGainVar;
  Byte_t  fWindowSizeHiGain;             // Number of Hi Gain slices in window
  Byte_t  fWindowSizeLoGain;             // Number of Lo Gain slices in window  

  Bool_t  fPedestalUpdate;
  
  MGeomCam     *fGeom;       // Camera geometry
  MBadPixelsCam *fBad;       // Bad Pixels
  
  TArrayI fNumEventsUsed;   // Number of events used for pedestal calc for each pixel
  TArrayI fTotalCounter;    // Counter for dumping values to Pedestal Container
  TArrayD fSumx;            // sum of values
  TArrayD fSumx2;           // sum of squared values
  TArrayD fSumAB0;          // sum of ABFlag=0 slices
  TArrayD fSumAB1;          // sum of ABFlag=1 slices
  
  Int_t  PreProcess ( MParList *pList );
  Bool_t ReInit     ( MParList *pList );
  Int_t  Process    ();
  Int_t  PostProcess();
  
public:

  MPedCalcFromLoGain(const char *name=NULL, const char *title=NULL);
  
  void Clear(const Option_t *o="");
  void SetRange(Byte_t hifirst=0, Byte_t hilast=0, Byte_t lofirst=0, Byte_t lolast=0);
  void SetWindowSize(Byte_t windowh=0, Byte_t windowl=0);
  void SetMaxHiGainVar(Byte_t maxvar=0);
  void SetDumpEvents(UInt_t dumpevents = 0) {fNumEventsDump = dumpevents;}
  void SetPedestalUpdate(Bool_t pedupdate)  {fPedestalUpdate = pedupdate;}
  
  TArrayI *GetNumEventsUsed() {return &fNumEventsUsed;};
  
  ClassDef(MPedCalcFromLoGain, 0)   // Task to calculate pedestals from pedestal runs raw data
};

#endif
