#ifndef MARS_MPedestalCam
#define MARS_MPedestalCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MGeomCam;
class MPedestalPix;
class MBadPixelsCam;

class MPedestalCam : public MParContainer, public MCamEvent
{
private:

  TClonesArray *fArray;           //-> FIXME: Change TClonesArray away from a pointer?
  TClonesArray *fAverageAreas;    //-> Array of MPedestalPix, one per pixel area
  TClonesArray *fAverageSectors;  //-> Array of MPedestalPix, one per camera sector

  UInt_t fTotalEntries;  // Total number of times, the Process was executed (to estimate the error of pedestal)

public:

  MPedestalCam(const char *name=NULL, const char *title=NULL);
  ~MPedestalCam();
  
  void Clear(Option_t *o="");
  
  // Getters 
        MPedestalPix &GetAverageArea   ( UInt_t i );
  const MPedestalPix &GetAverageArea   ( UInt_t i )            const;
  const Int_t         GetAverageAreas  ()                      const;
        MPedestalPix &GetAverageSector ( UInt_t i );
  const MPedestalPix &GetAverageSector ( UInt_t i )            const;
  const Int_t         GetAverageSectors()                      const;
  Float_t             GetPedestalMin   ( const MGeomCam *cam ) const;
  Float_t             GetPedestalMax   ( const MGeomCam *cam ) const;
  Int_t               GetSize          ()                      const;
  ULong_t             GetTotalEntries  ()                      const { return fTotalEntries; }
  
        MPedestalPix &operator[]       ( Int_t i             );
  const MPedestalPix &operator[]       ( Int_t i             ) const;

  void  Init                           ( const MGeomCam &geom);
  void  InitSize                       ( const UInt_t i      );
  void  InitAverageAreas               ( const UInt_t i      );
  void  InitAverageSectors             ( const UInt_t i      );

  void ReCalc(const MGeomCam &geom, MBadPixelsCam *bad=NULL);

  void Print(Option_t *o="") const;
  
  // Setters
  void SetTotalEntries(const ULong_t n) { fTotalEntries = n; }

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  ClassDef(MPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif
