#ifndef MARS_MPedCalcFromLoGain
#define MARS_MPedCalcFromLoGain

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MGeomCam;
class MBadPixelsCam;
class MRawEvtPixelIter;

class MPedCalcFromLoGain : public MExtractor
{
    static const Int_t fgCheckWinFirst;      // First FADC slice to check for signal (currently set to: 0)
    static const Int_t fgCheckWinLast;       // Last FADC slice to check for signal  (currently set to: 29)
    static const Int_t fgExtractWinFirst;      // First FADC slice to use for pedestal calculation (currently set to: 15)
    static const Int_t fgExtractWinSize;       // number of successive slices used to calculate pedestal (currently set to: 6)
    static const Int_t fgMaxSignalVar;     // The maximum difference between the highest and lowest slice

    Int_t   fNumEventsDump;      // Number of event after which MPedestalCam gets updated

    Int_t  fMaxSignalVar;
    Int_t  fCheckWinFirst;
    Int_t  fCheckWinLast;
    Int_t  fExtractWinSize;              // Number of slices to calculate the pedestal from
    Int_t  fExtractWinFirst;
    Int_t  fExtractWinLast;

    Bool_t  fPedestalUpdate;

    MGeomCam *fGeom;             // Camera geometry
    TString   fPedContainerName; // name of the 'MPedestalCam' container

    TArrayI fNumEventsUsed;      // Number of events used for pedestal calc for each pixel
    TArrayI fTotalCounter;       // Counter for dumping values to Pedestal Container
    TArrayD fSumx;               // sum of values
    TArrayD fSumx2;              // sum of squared values
    TArrayD fSumAB0;             // sum of ABFlag=0 slices
    TArrayD fSumAB1;             // sum of ABFlag=1 slices

    // MParContainer
    Int_t  PreProcess (MParList *pList);
    Bool_t ReInit     (MParList *pList);
    Int_t  Process    ();
    Int_t  PostProcess();
    Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    // Calculation
    void Calc(ULong_t n, UInt_t idx);

    //Helper function to extract slice values by slice number
    UInt_t GetSlice(MRawEvtPixelIter *pixel, UInt_t slice);

public:
    MPedCalcFromLoGain(const char *name=NULL, const char *title=NULL);

    // TObject
    void Clear(const Option_t *o="");

    // Setter
    void SetCheckRange(Int_t checkfirst=0, Int_t checklast=29);
    void SetExtractWindow(Int_t extractfirst=15, Int_t windowsize=6);
    void SetMaxSignalVar(Int_t maxvar=0)         { fMaxSignalVar = maxvar;    }
    void SetNumEventsDump(UInt_t dumpevents = 0) { fNumEventsDump = dumpevents;}
    void SetPedestalUpdate(Bool_t pedupdate)  {fPedestalUpdate = pedupdate;}

    void SetPedContainerName(const char *name) { fPedContainerName = name; }

    // Getter
    TArrayI *GetNumEventsUsed() { return &fNumEventsUsed; }

    ClassDef(MPedCalcFromLoGain, 0)   // Task to calculate pedestals from pedestal runs raw data
};

#endif
