#ifndef MARS_MPointingDev
#define MARS_MPointingDev

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MPointingDev : public MParContainer
{
private:
    Double_t fDevZd;  // [deg] Pointing offset zenith distance as calculated from starguider data
    Double_t fDevAz;  // [deg] Pointing offset azimuth as calculated from starguider dat

public:
    MPointingDev(const char *name=0, const char *title=0) : fDevZd(0), fDevAz(0)
    {
        fName  = name ? name   : "MPointingDev";
        fTitle = title ? title : "Container storing the telescope mispointing";
    }

    void SetDevZdAz(Double_t devzd, Double_t devaz) { fDevZd=devzd; fDevAz=devaz; }

    Double_t GetDevZd() const  { return fDevZd; }
    Double_t GetDevAz() const  { return fDevAz; }

    Double_t GetDevZdRad() const  { return fDevZd*TMath::DegToRad(); }
    Double_t GetDevAzRad() const  { return fDevAz*TMath::DegToRad(); }

    ClassDef(MPointingDev, 1) //Container storing the telescope mispointing
};

#endif
