/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  MRawCrateData
//
//  This container stores the information about one crate. A list of this
//  informations can be find at MRawCrateArray
//
/////////////////////////////////////////////////////////////////////////////
#include "MRawCrateData.h"

#include <iostream.h>
#include <iomanip.h>

#include <fstream.h>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MRawCrateData);

MRawCrateData::MRawCrateData() : fDAQCrateNumber(0), fFADCEvtNumber(0), fFADCClockTick(0)
{
}

// --------------------------------------------------------------------------
//
//  read the information from a binary input stream about the CRATE DATA,
//  like specified in a TDAS note
//
void MRawCrateData::ReadEvt(istream& fin)
{
    fin.read((Byte_t*)&fDAQCrateNumber, 2);
    fin.read((Byte_t*)&fFADCEvtNumber,  4);
    fin.read((Byte_t*)&fFADCClockTick,  4);
}

// --------------------------------------------------------------------------
//
//  print all stored information to gLog
//
void MRawCrateData::Print(Option_t *t) const
{
    *fLog << all;
    *fLog << "Crate Number " << fDAQCrateNumber << ":  ";
    *fLog << "FADCEventNr=" << fFADCEvtNumber << "  ";
    *fLog << "FADCClockTick=" << fFADCClockTick << " (20MHz)" << endl;
}
