#ifndef MARS_MReport
#define MARS_MReport

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MTime;
class MParList;

class MReport : public MParContainer
{
private:
    const TString fIdentifier;    //!
    const Bool_t  fHasReportTime; //!

    Byte_t  fState;
    MTime  *fTime;             //!

    ULong_t Hash() const { return fIdentifier.Hash(); }
    Bool_t InterpreteHeader(TString &str);

public:
    MReport(const char *id, Bool_t time=kTRUE) : fIdentifier(id), fHasReportTime(time), fState(0xff), fTime(0) { }

    virtual Bool_t SetupReading(MParList &plist);
    virtual Bool_t InterpreteBody(TString &str);

    Bool_t Interprete(TString &str);
    Bool_t CheckIdentifier(TString &str) const
    {
        if (!str.BeginsWith(fIdentifier))
            return kFALSE;

        str.Remove(0, fIdentifier.Length());
        str = str.Strip(TString::kBoth);

        return kTRUE;
    }

    const TString &GetIdentifier() const { return fIdentifier; }

    ClassDef(MReport, 1) // Base class for control reports
};

#endif
