#ifndef MARS_MReportCamera
#define MARS_MReportCamera

#ifndef MARS_MReport
#include "MReport.h"
#endif

class MCameraCooling;
class MCameraLids;
class MCameraHV;
class MCameraLV;
class MCameraAUX;
class MCameraCalibration;

class MReportCamera : public MReport
{
private:
    Byte_t fStatus;   // CaCo monitored status of the sentinel (0-9), Sentinel_state
    Byte_t fStatusDC; // CaCo monitored status of the DC currents (0-9), Cam.DC_state

    MCameraCooling     *fCooling;     //!
    MCameraLids        *fLids;        //!
    MCameraAUX         *fAUX;         //!
    MCameraHV          *fHV;          //!
    MCameraLV          *fLV;          //!
    MCameraCalibration *fCalibration; //!

    Bool_t SetupReading(MParList &plist);
    Bool_t CheckTag(TString &str, const char *tag) const;

    Bool_t InterpreteCamera(TString &str);
    Bool_t InterpreteDC(TString &str);
    Bool_t InterpreteHV(TString &str);
    Bool_t InterpreteCOOL(TString &str);
    Bool_t InterpreteLID(TString &str);
    Bool_t InterpreteHVPS(TString &str);
    Bool_t InterpreteLV(TString &str);
    Bool_t InterpreteAUX(TString &str);
    Bool_t InterpreteCAL(TString &str);

    Int_t  InterpreteBody(TString &str);

public:
    MReportCamera();

    Byte_t GetStatus() const { return  fStatus; }
    Byte_t GetStatusDC() const { return fStatusDC; }

    ClassDef(MReportCamera, 1) // Class for CAMERA-REPORT information
};

#endif
