#ifndef MARS_MTimeExtractor
#define MARS_MTimeExtractor

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

class MPedestalPix;
class MArrivalTimeCam;
class MTimeExtractor : public MExtractor
{
  
  MArrivalTimeCam *fArrTime;   // Container with the photons arrival times
  
  virtual Int_t PreProcess(MParList *pList);
  virtual Bool_t ReInit(MParList *pList);
  virtual Int_t Process();

  virtual void FindTimeHiGain(Byte_t *firstused, Float_t &time, Float_t &dtime,
                              Byte_t &sat, const MPedestalPix &ped) const;
  virtual void FindTimeLoGain(Byte_t *firstused, Float_t &time, Float_t &dtime,
                              Byte_t &sat, const MPedestalPix &ped) const;

public:

  MTimeExtractor(const char *name=NULL, const char *title=NULL);
 
  ClassDef(MTimeExtractor, 0)   // Arrival Time Extractor Base Class
};

#endif



