#ifndef MARS_MExtractTime
#define MARS_MExtractTime

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

class MPedestalPix;
class MArrivalTimeCam;

class MExtractTime : public MExtractor
{
private:
  static const Float_t fgOffsetLoGain;  // Default for fOffsetLoGain (now set to 1.51 (= 5ns)

  Int_t  PreProcess(MParList *pList);
  Bool_t ReInit(MParList *pList);
  Int_t  Process();

protected:
  Float_t fOffsetLoGain;     // Offset of the low-gain signal w.r.t. the High-Gain slices

  MArrivalTimeCam *fArrTime; //! Container with the photons arrival times
  
  virtual void FindTimeHiGain(Byte_t *firstused, Float_t &time, Float_t &dtime,
                              Byte_t &sat, const MPedestalPix &ped) const;
  virtual void FindTimeLoGain(Byte_t *firstused, Float_t &time, Float_t &dtime,
                              Byte_t &sat, const MPedestalPix &ped) const;

  Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);

public:
  MExtractTime(const char *name=NULL, const char *title=NULL);

  void SetOffsetLoGain( const Float_t f=fgOffsetLoGain) { fOffsetLoGain = f; }

  void Print(Option_t *o) const;

  ClassDef(MExtractTime, 1)   // Arrival Time Extractor Base Class
};

#endif
