#ifndef MARS_MExtractTimeAndChargeDigitalFilter
#define MARS_MExtractTimeAndChargeDigitalFilter

#ifndef MARS_MExtractTimeAndCharge
#include "MExtractTimeAndCharge.h"
#endif

#ifndef MARS_MArrayF
#include "MArrayF.h"
#endif

class TH1F;
class TH2F;
class MPedestalPix;
class MExtractTimeAndChargeDigitalFilter : public MExtractTimeAndCharge
{
private:
  static const Byte_t fgHiGainFirst;
  static const Byte_t fgHiGainLast;
  static const Byte_t fgLoGainFirst;
  static const Byte_t fgLoGainLast;
  static const Int_t  fgWindowSizeHiGain;
  static const Int_t  fgWindowSizeLoGain;
  static const Int_t  fgBinningResolutionHiGain;
  static const Int_t  fgBinningResolutionLoGain;
  static const Int_t  fgSignalStartBinHiGain;
  static const Int_t  fgSignalStartBinLoGain;
  
  MArrayF fHiGainSignal;          //! Need fast access to the signals in a float way
  MArrayF fLoGainSignal;          //! Store them in separate arrays

  Float_t fTimeShiftHiGain;
  Float_t fTimeShiftLoGain;
  
  Int_t   fSignalStartBinHiGain; //!
  Int_t   fSignalStartBinLoGain; //!

  Int_t   fWindowSizeHiGain;
  Int_t   fWindowSizeLoGain;

  Int_t   fBinningResolutionHiGain;
  Int_t   fBinningResolutionHalfHiGain;
  Int_t   fBinningResolutionLoGain;
  Int_t   fBinningResolutionHalfLoGain;
  
  MArrayF fAmpWeightsHiGain;     //!
  MArrayF fTimeWeightsHiGain;    //!
  MArrayF fAmpWeightsLoGain;     //!
  MArrayF fTimeWeightsLoGain;    //!

  Bool_t ReInit(MParList *pList);
  Int_t PreProcess(MParList *pList);

  Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);

protected:
  virtual void FindTimeAndChargeHiGain(Byte_t *firstused, Byte_t *logain, Float_t &sum, Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);
  virtual void FindTimeAndChargeLoGain(Byte_t *firstused, Float_t &sum,  Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);

public:

  MExtractTimeAndChargeDigitalFilter(const char *name=NULL, const char *title=NULL);  

  Bool_t WriteWeightsFile(TString filename,
                          TH1F *shapehi, TH2F *autocorrhi,
                          TH1F *shapelo=NULL, TH2F *autocorrlo=NULL );

  Bool_t ReadWeightsFile(TString filename="cosmic_weights.dat");
  void SetWindowSize(Int_t windowh=fgWindowSizeHiGain,
                     Int_t windowl=fgWindowSizeLoGain);

  void SetBinningResolution(const Int_t rh=fgBinningResolutionHiGain, const Int_t rl=fgBinningResolutionLoGain)  {
    fBinningResolutionHiGain     = rh & ~1;
    fBinningResolutionHalfHiGain = fBinningResolutionHiGain/2;
    fBinningResolutionLoGain     = rl & ~1;
    fBinningResolutionHalfLoGain = fBinningResolutionLoGain/2;
  }
  

  void SetSignalStartBin( const Int_t sh=fgSignalStartBinHiGain, const Int_t sl=fgSignalStartBinLoGain) {
    fSignalStartBinHiGain = sh;
    fSignalStartBinLoGain = sl; 
  }

  void Print(Option_t *o) const;
  
  ClassDef(MExtractTimeAndChargeDigitalFilter, 1)   // Hendrik's digital filter
};

#endif
