#ifndef MARS_MSimPointingPos
#define MARS_MSimPointingPos

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MCorsikaEvtHeader;
class MCorsikaRunHeader;
class MPointingPos;

class MSimPointingPos : public MTask
{
private:
    MCorsikaRunHeader *fRunHeader;  //! Header storing event information
    MCorsikaEvtHeader *fEvtHeader;  //! Header storing event information
    MPointingPos      *fPointing;   //! Output storing telescope poiting position

    // MParContainer
    //Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print=kFALSE);

    // MTask
    Int_t PreProcess(MParList *pList);
    Int_t Process();


public:
    MSimPointingPos(const char *name=NULL, const char *title=NULL);

    // MSimPointingPos

    // TObject

    ClassDef(MSimPointingPos, 0) // Task to simulate the pointing position (mirror orientation)
};
    
#endif

