#ifndef MARS_MHPhotonEvent
#define MARS_MHPhotonEvent

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

#ifndef ROOT_TProfile2D
#include <TProfile2D.h>
#endif

class MPhotonEvent;

class MHPhotonEvent : public MH
{
private:
    TH2D       fHistXY;
    TH2D       fHistUV;
    TProfile2D fHistT;
    TH1D       fHistWL;

    Int_t      fType;
    Bool_t     fPermanentReset;

    void Init(const char *name, const char *title);

    Bool_t SetupFill(const MParList *pList);
    Int_t  Fill(const MParContainer *par, const Stat_t weight=1);
    //Bool_t Finalize();

public:
    MHPhotonEvent(Double_t max=0, const char *name=0, const char *title=0);
    MHPhotonEvent(Int_t type,     const char *name=0, const char *title=0);

    void Draw(Option_t *o="");
    void Paint(Option_t *o="");

    ClassDef(MHPhotonEvent, 1) // Histogram to display the information of MPhotonEvents
};

#endif
