#ifndef MARS_MSimAbsorption
#define MARS_MSimAbsorption

#ifndef MARS_MTask
#include "MTask.h"
#endif

class TSpline3;

class MParList;
class MSpline3;
class MPhotonEvent;
class MCorsikaEvtHeader;

class MSimAbsorption : public MTask
{
private:
    MPhotonEvent      *fEvt;     //! Event stroing the photons
    MCorsikaEvtHeader *fHeader;  //! Header storing event information

    MSpline3          *fSpline;  //! Spline to interpolate wavelength or incident angle

    TString fFileName;           // FileName of the file containing the curve
    Bool_t  fUseTheta;           // Switches between using wavelength or incident angle

    // MParContainer
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print=kFALSE);

    // MTask
    Int_t  PreProcess(MParList *pList);
    Bool_t ReInit(MParList *pList);
    Int_t  Process();

    // MSimAbsorption
    MSpline3 *ReadSpline(const char *fname);

public:
    MSimAbsorption(const char *name=NULL, const char *title=NULL);
    ~MSimAbsorption();

    // MSimAbsorption
    Bool_t ReadFile(const char *fname=0);
    void SetFileName(const char *fname) { fFileName=fname; }

    void SetUseTheta(Bool_t b=kTRUE) { fUseTheta = b; }

    void InitUnity(UInt_t n, Float_t min, Float_t max);

    void Multiply(const char *fname);
    void Multiply(const TSpline3 &spline);
    void Multiply(UInt_t n, const Double_t *x, const Double_t *y);

    // TObject
    void Clear(Option_t *o="");

    ClassDef(MSimAbsorption, 0) // Task to calculate wavelength or incident angle dependent absorption
};

#endif
