#ifndef MARS_MStarPos
#define MARS_MStarPos

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MStarPos : public MParContainer
{
private:

    //Expected position on camera
    Float_t fMagExp;
    Float_t fXExp;    //[mm]
    Float_t fYExp;    //[mm]

    //Ideal position on camera
    Float_t fMagIdeal;
    Float_t fXIdeal;    //[mm]
    Float_t fYIdeal;    //[mm]

    //Info from calculation
    Float_t fMagCalc;
    Float_t fMaxCalc;            //[uA]
    Float_t fMeanXCalc;          //[mm]
    Float_t fMeanYCalc;          //[mm]
    Float_t fSigmaMinorAxisCalc; //[mm]
    Float_t fSigmaMajorAxisCalc; //[mm]

    //Info from uncorrelated Gauss fit
    Float_t fMagFit;
    Float_t fMaxFit;             //[uA]
    Float_t fMeanXFit;           //[mm]
    Float_t fMeanYFit;           //[mm]
    Float_t fSigmaMinorAxisFit;  //[mm]
    Float_t fSigmaMajorAxisFit;  //[mm]
    Float_t fXXErr;          
    Float_t fXYErr;
    Float_t fYYErr;

    Float_t fChiSquare;
    Int_t   fNdof;

    //Info from correlated Gauss fit
    Float_t fMagCGFit;
    Float_t fMaxCGFit;             //[uA]
    Float_t fMeanXCGFit;           //[mm]
    Float_t fMeanYCGFit;           //[mm]
    Float_t fSigmaXCGFit;          //[mm]
    Float_t fSigmaYCGFit;          //[mm]
    Float_t fCorrXYCGFit;          // correlation coefficient
    Float_t fXXErrCGFit;           // error matrix of (fMeanXCGFit,fMeanYCGFit)
    Float_t fXYErrCGFit;
    Float_t fYYErrCGFit;

    Float_t fChiSquareCGFit;
    Int_t   fNdofCGFit;


public:

    MStarPos(const char *name=NULL, const char *title=NULL);
    //~MStarPos();

    Float_t GetMagExp() {return fMagExp;}
    Float_t GetXExp() {return fXExp;}
    Float_t GetYExp() {return fYExp;}

    Float_t GetMagIdeal() {return fMagIdeal;}
    Float_t GetXIdeal() {return fXIdeal;}
    Float_t GetYIdeal() {return fYIdeal;}

    Float_t GetMagCalc() {return fMagCalc;}
    Float_t GetMaxCalc() {return fMaxCalc;}
    Float_t GetMeanXCalc() {return fMeanXCalc;}
    Float_t GetMeanYCalc() {return fMeanYCalc;}
    Float_t GetSigmaMinorAxisCalc() {return fSigmaMinorAxisCalc;}
    Float_t GetSigmaMajorAxisCalc() {return fSigmaMajorAxisCalc;}

    Float_t GetMagFit() {return fMagFit;}
    Float_t GetMaxFit() {return fMaxFit;}
    Float_t GetMeanXFit() {return fMeanXFit;}
    Float_t GetMeanYFit() {return fMeanYFit;}
    Float_t GetSigmaMinorAxisFit() {return fSigmaMinorAxisFit;}
    Float_t GetSigmaMajorAxisFit() {return fSigmaMajorAxisFit;}
    Float_t GetChiSquare() {return fChiSquare;}
    UInt_t GetNdof() {return fNdof;}
    Float_t GetChiSquareNdof() {return fChiSquare/fNdof;}

    Float_t GetMeanX() {return fMeanXFit!=0?fMeanXFit:fMeanXCalc;}
    Float_t GetMeanY() {return fMeanXFit!=0?fMeanYFit:fMeanYCalc;}
    Float_t GetSigmaMinorAxis() {return fSigmaMinorAxisFit!=0?fSigmaMinorAxisFit:fSigmaMinorAxisCalc;}
    Float_t GetSigmaMajorAxis() {return fSigmaMajorAxisFit!=0?fSigmaMajorAxisFit:fSigmaMajorAxisCalc;}
    
    // getters for the correlated Gauss fit
    Float_t GetMagCGFit()           {return fMagCGFit;}
    Float_t GetMaxCGFit()           {return fMaxCGFit;}
    Float_t GetMeanXCGFit()         {return fMeanXCGFit;}
    Float_t GetMeanYCGFit()         {return fMeanYCGFit;}
    Float_t GetSigmaXCGFit()        {return fSigmaXCGFit;}
    Float_t GetSigmaYCGFit()        {return fSigmaYCGFit;}
    Float_t GetCorrXYCGFit()        {return fCorrXYCGFit;}
    Float_t GetXXErrCGFit()         {return fXXErrCGFit;}
    Float_t GetXYErrCGFit()         {return fXYErrCGFit;}
    Float_t GetYYErrCGFit()         {return fYYErrCGFit;}
    Float_t GetChiSquareCGFit()     {return fChiSquareCGFit;}
    UInt_t GetNdofCGFit()           {return fNdofCGFit;}
    Float_t GetChiSquareNdofCGFit() {return fChiSquareCGFit/fNdofCGFit;}


    void Reset();

    void SetExpValues(Float_t mag, Float_t x, Float_t y);

    void SetIdealValues(Float_t mag, Float_t x, Float_t y);

    void SetCalcValues(Float_t mag, Float_t max, Float_t x, Float_t y, 
                       Float_t sigmaMinorAxis, Float_t sigmaMajorAxis);

    void SetFitValues(Float_t mag, Float_t max, Float_t x, Float_t y, 
                      Float_t sigmaMinorAxis, Float_t sigmaMajorAxis, 
                      Float_t chi, Int_t ndof);

    void SetFitValues(Float_t mag, Float_t max, Float_t x, Float_t y, 
                      Float_t sigmaX, Float_t sigmaY, 
                      Float_t chi, Int_t ndof, 
                      Float_t xx, Float_t xy, Float_t yy);

    void SetCGFitValues(Float_t mag, Float_t max, Float_t x, Float_t y, 
                        Float_t sigmaX, Float_t sigmaY, Float_t correlation, 
                        Float_t xx, Float_t xy, Float_t yy,
                        Float_t chi, Int_t ndof);

    void Paint(Option_t *opt=NULL);
    void Print(Option_t *opt=NULL) const;

    ClassDef(MStarPos, 1) // Container that holds the star information in the PMT camera
};

#endif


