#ifndef MARS_MLiveTime
#define MARS_MLiveTime

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MLiveTime : public MParContainer
{
 private:
  
  UInt_t fNumberTimeBins;
  TArrayD fLiveTimeBin;
  TArrayD fMeanRealTimeBin;
  TArrayD fWidthRealTimeBin;
  
  void Set(UInt_t numberbins);

 public:

  MLiveTime(UInt_t numberbins = 1, const char *name=NULL, const char *title=NULL);
  //~MLiveTime;

  void AddBin() { Set(fNumberTimeBins+1); }
  void AddTime(Double_t time) { fLiveTimeBin[fNumberTimeBins-1]+=time; }
  void SetRealTime (Double_t mean, Double_t width)
      {
	  fMeanRealTimeBin[fNumberTimeBins-1]=mean;
	  fWidthRealTimeBin[fNumberTimeBins-1]=width;
      }

  UInt_t GetNumberTimeBins() { return fNumberTimeBins;}
  Double_t GetLiveTime() { return fLiveTimeBin[fNumberTimeBins-1]; }
  Double_t GetMeanRealTime() { return fMeanRealTimeBin[fNumberTimeBins-1]; }
  Double_t GetWidthRealTime() { return fWidthRealTimeBin[fNumberTimeBins-1]; }

  Double_t* GetLiveTimeArray()   { return fLiveTimeBin.GetArray(); }
  Double_t* GetMeanRealTimeArray()   { return fMeanRealTimeBin.GetArray(); }
  Double_t* GetWidthRealTimeArray()   { return fWidthRealTimeBin.GetArray(); }

  void Print(const Option_t*) const;

 ClassDef(MLiveTime, 1)    // Storage for the live time extracted from real data

};

#endif
