#ifndef MARS_MDCA 
#define MARS_MDCA

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MDCA.cc                                                                 //
// Container to store the DCA stuff                                        //
//                                                                         //
// Author(s): S.C. Commichau, L.S. Stark, 7/2003                           //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include <TArrayF.h>
#include <TEllipse.h>
#include <TLine.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <TStyle.h> 
#include <TMath.h>
#include <math.h>
#include <TPad.h>
#include <TRandom.h>
#include <TRandom2.h>
#include <fstream>
#include <iostream>

#include "MLog.h"
#include "MLogManip.h"
#include "MGeomCam.h"
#include "MGeomPix.h"
#include "MCerPhotPix.h"
#include "MCerPhotEvt.h"
#include "MHillas.h"

// Add offsets to the Width and Length to draw nice lines
#define OffsetW 20.0
#define OffsetL 440.0

#define kmm2Deg 0.00317460317
#define TwoPi 6.28318530717958623 

class TArrayF;
class TEllipse;
class MGeoCam;
class MCerPhotEvt;
class MHillas;

class MDCA : public MParContainer
{
 private:
    
    Float_t fLength;  // [mm]   major axis of ellipse
    Float_t fWidth;   // [mm]   minor axis of ellipse
    Float_t fDelta0;  // [rad]  angle of major axis with x-axis (-Pi/2 .. Pi/2)
    Float_t fDelta1;  // [rad]  my angle of major axis with x-axis (0 .. 2*Pi)
    Float_t fMeanX;   // [mm]   x-coordinate of center of ellipse
    Float_t fMeanY;   // [mm]   y-coordinate of center of ellipse
    Float_t fX1W;     // [mm]   x-coordinate of 1st point of Lline
    Float_t fY1W;     // [mm]   y-coordinate of 1st point of Lline
    Float_t fX2W;     // [mm]   x-coordinate of 2nd point of Lline
    Float_t fY2W;     // [mm]   y-coordinate of 2nd point of Lline
    Float_t fX1L;     // [mm]   x-coordinate of 1st point of Wline
    Float_t fY1L;     // [mm]   y-coordinate of 1st point of Wline
    Float_t fX2L;     // [mm]   x-coordinate of 2nd point of Wline
    Float_t fY2L;     // [mm]   y-coordinate of 2nd point of Wline
    Double_t fDCA;    // [mm]   Distance of Cloasest Approach 
    Float_t fXDCA;    // [mm]   x-coordinate of 2nd point of the DCA-line 
    Float_t fYDCA;    // [mm]   y-coordinate of 2nd point of the DCA-line  
    Float_t fXRef;    // [mm]   x-coordinate of reference point
    Float_t fYRef;    // [mm]   y-coordinate of reference point
    Float_t fmu;
    Float_t flambda;  
    Float_t fr1, fr2; // [mm] Coordinates of the orientation vector of the shower axis
    Float_t fd1, fd2; // [mm] Coordinates of the DCA vector
    Float_t gx, gy;
   
    TEllipse *fEllipse;   // Graphical object to draw the ellipse, ROOT!
    TEllipse *fRefCircle; // To draw reference point

    TLine *fLineL;        // Shower axis
    TLine *fLineW;        // Line perpendicular to the shower axis
    TLine *fLineX;        // x-axis of the coordinate system 
    TLine *fLineY;        // y-axis of the coordinate system  
    TLine *fLineDCA;      // DCA line
    TLine *fLineMean;     // Line to COG of the shower 

 public:
    MDCA(const char *name=NULL, const char *title=NULL);

    ~MDCA();

    void Reset();

    Int_t Calc(const MGeomCam &geom, const MCerPhotEvt &pix, const MHillas &hil);

    void Print(Option_t *opt=NULL) const;

    void Paint(Option_t *opt=NULL);

    void Clear(Option_t *opt=NULL);

    void SetRefPoint(const Float_t fXRef0, const Float_t fYRef0);
    
    Float_t GetDCA() const { return fDCA; }
 
    Float_t GetDelta() const { return fDelta1; }

    ClassDef(MDCA, 1) 

};

#endif





