/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cherenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Author(s): Daniel Mazin, 05/2004 <mailto:mazin@imppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */


// Daniel Mazin 14.05.2004  mazin@mppmu.mpg.de
// **********************************************************************************
// this macro is used to produce false source plots 
// either using one sample only (usually used for OFF, set TYPEOPTION = kFALSE)
// or in addition using the background estimation from OFF (set TYPEOPTION = kTRUE).
// The later option can be used ONLY if false source method for the OFF data 
// has taken place before.
// input: hillas parameter file
// output: several 2D plots in a root file + 
// ascii file with parameters like significance, Nexcess etc.
// **********************************************************************************


// you may want to change these values:
#define STEPGRID 0.05 //  [deg]
#define MINXGRID -1.  //  [deg]
#define MINYGRID -1.  //  [deg]
#define MAXXGRID 1.   //  [deg]
#define MAXYGRID 1.   //  [deg]

#define ALPHAMAX 10.  // [deg], ON region in the alpha plot, maybe 5 deg is better
                      // NOTE: up to now only values of 5, 10, 15, 20 degrees are possible

// if you wish to rotate set to kTRUE, else kFALSE
const Bool_t ROTOPTION = kFALSE; 
const Bool_t TYPEOPTION = kFALSE; // kFALSE = estimate background from the same sample
                                  // kTRUE  = estimate background also from OFF data
const Bool_t CUTOPTION = kTRUE;  // kTRUE = dynamical cuts
                                 // kFALSE = statical cuts

/* ******************************************************   */
      /*  static    cuts   */
#define LENGTHMIN 0.10  // deg
#define LENGTHMAX 0.32  // deg
#define WIDTHMIN  0.06  // deg
#define WIDTHMAX  0.15  // deg
#define SIZEMIN   2000. // photons
#define DISTMIN   0.6   // deg
#define DISTMAX   1.3   // deg
#define LEAKMAX   0.25  // deg
/* ******************************************************   */

/* ******************************************************   */
      /*  dynamical cuts  Crab 27th Jan 2004 */
#define LENGTHMINParA 0.136  // deg
#define LENGTHMINParB 0.036  //
#define LENGTHMINParC -0.0038  //
#define LENGTHMAXParA 0.332  // deg
#define LENGTHMAXParB 0.037  //
#define LENGTHMAXParC 0.0261 //
#define WIDTHMINParA  0.063  // deg
#define WIDTHMINParB  0.013  //
#define WIDTHMINParC  0.0003  //
#define WIDTHMAXParA  0.123  // deg
#define WIDTHMAXParB  0.019  //
#define WIDTHMAXParC  0.0005 //
#define DISTMINParA   0.6   // deg
#define DISTMINParB   0.059  //
#define DISTMINParC   0.  //
#define DISTMAXParA   1.25   // deg
#define DISTMAXParB   0.059  //
#define DISTMAXParC   0.  //
/* ******************************************************   */

      /*  dynamical cuts  Mrk 421 and Crab 15th Feb 2004 */

/*
#define LENGTHMINParA 0.12  // deg
#define LENGTHMINParB 0.034  //
#define LENGTHMINParC 0.  //
#define LENGTHMAXParA 0.32  // deg
#define LENGTHMAXParB 0.034  //
#define LENGTHMAXParC 0. //
#define WIDTHMINParA  0.055  // deg
#define WIDTHMINParB  0.013  //
#define WIDTHMINParC  0.0  //
#define WIDTHMAXParA  0.12  // deg
#define WIDTHMAXParB  0.013  //
#define WIDTHMAXParC  0.0 //
#define DISTMINParA   0.6   // deg
#define DISTMINParB   0.059  //
#define DISTMINParC   0.  //
#define DISTMAXParA   1.25   // deg
#define DISTMAXParB   0.059  //
#define DISTMAXParC   0.  //
*/
/* ******************************************************   */

// please do not change these values:
#define NUMSTEPS (int) ((MAXXGRID - MINXGRID) / STEPGRID + 1.5)
#define GRIDBINS (int) (NUMSTEPS * NUMSTEPS  + 0.5)


#include "mtools.C"
#include <skyplot.h>  // needed histograms

// this helps me to check if the binning is ok
#define TOLERANCE 1e-3

#include "hillasfileread.C"
#include "gridloop.C"

void falsesourcemethod()
{

  if (TYPEOPTION == kTRUE)  // output of OFF data sample
//      DATPARAMIN = "data/ressignOffMrk3004.dat";  // 3000
      DATPARAMIN = "paramOffCrab2701.dat";   // 2000


   HILLASFILENAME = "~/data/Crab/2004_01_27/CrabHillasOFF.root";
   DATPARAMOUT = "paramOffCrab2701.dat";
   ROOTPLOTNAME = "/.magic/magicserv01/scratch/Daniel/plots/RootPlots/Crab/2004_01_27/CrabOffSkyPlots.root";
   hillasfileread();
   gridloop();  

/*
// use this loop for different subsamples
  for(Int_t i=1; i<10; i++)
  {
   HILLASFILENAME = "~/data/Crab15022004Update/sample";
   DATPARAMOUT = "data/ressignOnOffCrab1502Samp";
   ROOTPLOTNAME = "/.magic/magicserv01/scratch/Daniel/plots/RootPlots/Crab15022004Update/Crab1502Sample";

   HILLASFILENAME += i;
   HILLASFILENAME += "/";
   HILLASFILENAME += "CrabHillasON";
   HILLASFILENAME += ".root";

   DATPARAMOUT += i;
   DATPARAMOUT += "_AlphaCut";
   DATPARAMOUT += TMath::Nint(ALPHAMAX);
   DATPARAMOUT += "deg";
   DATPARAMOUT += ".dat";

   ROOTPLOTNAME += i;
   ROOTPLOTNAME += "_AlphaCut";
   ROOTPLOTNAME += TMath::Nint(ALPHAMAX);
   ROOTPLOTNAME += "deg";
   ROOTPLOTNAME += ".root";


   hillasfileread();
   gridloop();  
  }
*/
}
