/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cherenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Author(s): Daniel Mazin, 05/2004 <mailto:mazin@imppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

// Daniel Mazin 14.05.2004  mazin@mppmu.mpg.de
// **********************************************************************************
// this macro is used to make an image cleaning and calculate the Hillas parameters
// input:  calibrated data (one or more files using wild card)
// output: hillas parameter
// **********************************************************************************

#include "cleaninghillas.C"
void callcleaning()
{
  gROOT->Reset();

  TString typeInput ="ON";  // -> please specify "ON" or "OFF"

  const char *onfile="1*.ON";
  const char *offfile="1*.OFF";


  TString sourcename = "Crab";
  TString inPath;  // directory where to find calibrated files
  TString outPath; // directory where to write root-file with hillas parameters


  inPath = "/.magic/magicserv01/scratch/David/CalibratedData/Crab/2004_01_27/";

  outPath = "~mazin/data/Crab/2004_01_27/";

  cleaninghillas(onfile, offfile, typeInput, inPath, outPath, sourcename);

  cout << " finished, back from callcleaning " << endl;
  cout << " Hillas file " << outPath << sourcename << "Hillas" << typeInput << ".root is created " << endl;

}
