#ifndef MARS_MVPTime
#define MARS_MVPTime

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MVPTime : public MParContainer
{
private:
  Double_t fUT1;
  Int_t fYear;
  Int_t fMonth;
  Int_t fDay;
  Double_t MVPTime::CalendarToUT1(UInt_t yr, UInt_t mo, UInt_t dy, UInt_t hr, UInt_t mi, UInt_t se);
 
public:
  MVPTime(const char *name=NULL, const char *title=NULL);
  ~MVPTime();

  void SetTime(UInt_t yr, UInt_t mo, UInt_t dy, UInt_t hr, UInt_t mi, UInt_t se);
  void SetMJD(Double_t mjd, Double_t fracMjd = 0);
  inline Double_t GetMJD() { return fUT1; }

  void Print(Option_t *) const;

  Double_t MJDStartOfYear(UInt_t year);
  Double_t GetYear() { return fYear; }
  Double_t GetMonth() { return fMonth; }
  Double_t GetDay() { return fDay; }
  
  ClassDef(MVPTime, 1)

};

#endif

