/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Nicola Galante 09/2004 <mailto:nicola.galante@pi.infn.it>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MagicTrigger
// ------------
//
// Camera Display Games: Reversi
//
// Start the game by:
//   MagicReversi reversi;
//
//  Rules:
//  ------
//
// Use the mouse to put a stone at some place. If between your newly
// placed stone and the next stone (in a row) of your color are stones
// of other colors this stones are won by you. You can only place a
// stone if you win at least one stone from your 'enemy'. If you
// cannot do so, you are skipped. If nobody can make a move anymore
// the game is over. The player has won who has the most stones in
// his own color.
// The present player is indicated by <*>
// Use the Escape key to abort a game.
// If the game was aborted or has been stopped youcan access the
// options in the context menu.
//
////////////////////////////////////////////////////////////////////////////
#include "MagicTriggerButton.h"

#include <iostream>

#include <KeySymbols.h>

#include <TText.h>
#include <TMarker.h>
#include <TRandom.h>
#include <TCanvas.h>
#include <TClonesArray.h>
#include <TInterpreter.h>
#include <TRootEmbeddedCanvas.h>
#include <TGButton.h>
#include <TGTextEntry.h>
#include <TGTextBuffer.h>
#include <TGClient.h>
#include <TQObject.h>
//#include <RQ_OBJECT.h>

#include "MHexagon.h"
#include "MagicTriggerDisplay.h"
#include "MGeomPix.h"
#include "MGeomCamCT1.h"
#include "MGeomCamMagic.h"

ClassImp(MagicTriggerButton);

using namespace std;


// ------------------------------------------------------------------------
//
//  default constructor
//
MagicTriggerButton::MagicTriggerButton(const TGWindow *p, const char* text, Int_t id, 
				       GContext_t norm, FontStruct_t font, 
				       UInt_t option): TGTextButton(p,text)
{
    // Create a main frame
    //fButton = new TGTextButton(p,text);

    this->Connect("Clicked()","MagicTriggerButton",this,"Signal(Int_t,Int_t)");
    //this->Connect("Clicked()","MagicTriggerDisplay",gROOT->FindObject("MagicTriggerDisplay"),"Update()");

 }


void MagicTriggerButton::SetValue(const Int_t cell, const Int_t lut)
{
    fValue[0] = (Long_t)cell;
    fValue[1] = (Long_t)lut;
}

void MagicTriggerButton::Clicked()
{
    //TQObject::Disconnect(this,"Signal(Int_t,Int_t)",gROOT->FindObject("MagicTriggerDisplay"),"Update(Int_t,Int_t)");
    //this->Connect("Signal(Int_t,Int_t)","MagicTriggerDisplay",gROOT->FindObject("MagicTriggerDisplay"),"Update(Int_t,Int_t)");
    Emit("Clicked()");
}

void MagicTriggerButton::Signal(Int_t cell, Int_t lut)
{
    //this->SetValue(cell,lut);
    Emit("Signal(Int_t, Int_t)",fValue);
    //cout << fValue[0] << " ---- " << fValue[1] << endl;
}

//Bool_t MagicTriggerButton::Connect(const char *signal, const char *receiver_class,
//				  void *receiver, const char *slot)
//{
//   return TQObject::Connect(this,signal, receiver_class, receiver, slot);
//}
