#ifndef MARS_MHFlux
#define MARS_MHFlux

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include <TH2.h>
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif


class MParList;

class MHExcessEnergyTheta;
class MHMcCollectionArea;
class MHEffectiveOnTime;


class MHFlux : public MH
{
private:
 
    TH2D fHist;
    TH1D fAverageFlux;

    Bool_t SetupFill(const MParList *pList);
    Bool_t ReInit(MParList *pList);


public:
 
   MHFlux(const char *name=NULL, const char *title=NULL);

   void Calc(MHExcessEnergyTheta* hex, MHMcCollectionArea* area, MHEffectiveOnTime* hEffTime);

    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TH2D *GetHist()        { return &fHist; }
    TH1D *GetAverageFlux() { return &fAverageFlux; }

    void Draw(Option_t *option="");

    ClassDef(MHFlux, 1) //2D-histogram of Flux vs. Energy and theta
};

#endif
