#ifndef MARS_MHExcessEnergyTheta
#define MARS_MHExcessEnergyTheta

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include <TH2.h>
#endif


class MParList;
class MHAlphaEnergyTheta;
    
class MHExcessEnergyTheta : public MH
{
private:
 
    TH2D fHist;

    Bool_t SetupFill(const MParList *pList);
    Bool_t ReInit(MParList *pList);


public:
 
   MHExcessEnergyTheta(const char *name=NULL, const char *title=NULL);

   void Calc(MHAlphaEnergyTheta* hAlpha);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TH2D *GetHist()       { return &fHist; }

    void Draw(Option_t *option="");

    ClassDef(MHExcessEnergyTheta, 1) //2D-histogram in number of excess events vs. Energy and theta
};

#endif
