/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Martin Merck, 05/2004 <mailto:merck@astro.uni-wuerzburg.de>
!              Markus Gaug, 11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */
/////////////////////////////////////////////////////////////////////////////
//
//  stdPed.C
//
//  This macros is based on the calibration macro from Markus Gaug.
//  It processes a Pedestal file and writes a file with the containers
//
//  Needed arguments are retrieved from the file "marsconfig".
//  A typical config file looks like this:
//   inpath:                  /data/MAGIC/Period015/rootdata/2004_03_21/
//   outpath:                 /data/MAGIC/Period015/calibdata/2004_03_21/
//   pedfile001:              21297
//
//  inpath:     is the path to the merpped root files
//  outpath:    is the path where to store the F0 files
//  pedfilexxx: specifies which pedestal files to use. If more then 1 file
//              is specified, all files are processed but only 1 output file
//              is written.
//
//  The macro loops over the pedestal file using the class MJPedestal
//
/////////////////////////////////////////////////////////////////////////////

void stdPed()
{
  // turn of colors for logging to a file
  gLog.SetNoColors();

  // Get configuration from the "marsconfig" configuration file.
  TEnv env("marsconfig");

  // Here we get the input and output directory paths from the configuration
  // file
  const char* inpath = env.GetValue("inpath",".");
  const char* outpath = env.GetValue("outpath",".");

  //
  // Choose the signal Extractor:
  //
  //  MExtractFixedWindowPeakSearch extractor;
  //  MExtractSlidingWindow  extractor;
   MExtractFixedWindow    extractor;

  //
  // Set Ranges or Windows
  //
   extractor.SetRange(3,14,3,14);
  //  extractor.SetWindows(8,8);

  //
  // Choose the arrival time Extractor:
  //
  //  MExtractTimeHighestIntegral timeext;
  MExtractTimeFastSpline timeext;
  //
  // Set Ranges or Windows
  //
  timeext.SetRange(2,12,4,14);

  // Get all pedestal files to process
  // You can specify up to 999 files in the marsconfig file
  // all files are concatenated and processed as one single file.
  MRunIter pruns;
  char str[11];
  for( Int_t i = 1 ; i<1000; i++)
  {
     sprintf( str, "pedfile%03d", i);
     Int_t prun = env.GetValue( str, 0);
     if( prun == 0)
        break;
     pruns.AddRun(prun,inpath);
  }

  gStyle->SetOptStat(1);
  gStyle->SetOptFit();

  // We do not use any display here.
//  MStatusDisplay *display = new MStatusDisplay;
//  display->SetUpdateTime(3000);
//  display->Resize(850,700);

  /************************/
  /* PEDESTAL COMPUTATION */
  /************************/

  MCalibrationQECam qecam;
  MBadPixelsCam     badcam;
  MGeomCamMagic     geomcam;
  MGeomApply        geomapl;
  //
  // If you want to exclude pixels from the beginning, read
  // an ascii-file with the corr. pixel numbers (see MBadPixelsCam)
  //
//  badcam.AsciiRead("badpixels.dat");

  MJPedestal pedloop;
  pedloop.SetExtractor(&extractor);
  pedloop.SetInput(&pruns);
  pedloop.SetOutputPath(outpath);
//  pedloop.SetDisplay(display);
  pedloop.SetBadPixels(badcam);

  if (!pedloop.Process())
    return;

}


