#ifndef MARS_MIslandCalc
#define MARS_MIslandCalc

#ifndef MARS_MGTask
#include "MGTask.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class MGeomCam;
class MSigmabar;
class MCerPhotPix;
class MCerPhotEvt;
class MPedestalCam;
class MIslands;

class MIslandCalc : public MGTask
{
 private:
    const MGeomCam    *fCam;        //!
    MCerPhotEvt       *fEvt;        //!
    MSigmabar         *fSgb;        //!
    MPedestalCam      *fPed;        //!

    MIslands          *fIsl;        //!    output container to store result
   
    Int_t PreProcess(MParList *plist);
    Int_t Process();
           
 public:
    MIslandCalc(const char *name=NULL, const char *title=NULL);

    ClassDef(MIslandCalc, 0)        // task doing the image cleaning
}; 

#endif
