/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lopez 04/2004 <mailto:jlopez@ifae.es>
!   Author(s): Jordi Albert 04/2004 <mailto:albert@astro.uni-wuerzburg.de>
!                 
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MStarLocalCam
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MStarLocalCam.h"
#include "MStarLocalPos.h"

#include <TList.h>


// --------------------------------------------------------------------------
// Default constructor. 
//
//
MStarLocalCam::MStarLocalCam(const char *name, const char *title) 
{
  fName  = name  ? name  : "MStarLocalCam";
  fTitle = title ? title : "";
  
  fStars = new TList;
}

MStarLocalCam::~MStarLocalCam()
{
    delete fStars;
}

// --------------------------------------------------------------------------
//
// Get i-th
//
MStarLocalPos &MStarLocalCam::operator[] (Int_t i)
{
    return *static_cast<MStarLocalPos*>(fStars->At(i));
}

// --------------------------------------------------------------------------
//
// Get i-th
//
const MStarLocalPos &MStarLocalCam::operator[] (Int_t i) const
{
    return *static_cast<MStarLocalPos*>(fStars->At(i));
}

void MStarLocalCam::Print(Option_t *o) const
{
	//loop to extract position of stars on the camera
	TIter Next(fStars);
	MStarLocalPos* star;
	while ((star=(MStarLocalPos*)Next())) 
	    star->Print();
}
