/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lpez , 4/2004 <mailto:jlopez@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */
#include "MStarLocalPos.h"

#include <TEllipse.h>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MStarLocalPos);

using namespace std;

MStarLocalPos::MStarLocalPos(const char *name, const char *title)
{

    fName  = name  ? name  : "MStarLocalPos";
    fTitle = title ? title : "";
    
    Reset();
}

void MStarLocalPos::Reset()
{

    //Expected position on camera
     fMagExp = 0.;
     fXExp = 0.;
     fYExp = 0.;

    //Info from calculation

     fMagCalc = 0.;
     fMeanXCalc = 0.;
     fMeanYCalc = 0.;
     fSigmaMinorAxisCalc = 0.;
     fSigmaMajorAxisCalc = 0.;

    //Info from fit

     fMagFit = 0.;
     fMeanXFit = 0.;
     fMeanYFit = 0.;
     fSigmaMinorAxisFit = 0.;
     fSigmaMajorAxisFit = 0.;
     fChisquarenDof = 0.;

}

void MStarLocalPos::SetExpValues(Float_t mag, Float_t x, Float_t y)
{
     fMagExp = mag;
     fXExp = x;
     fYExp = y;
}

void MStarLocalPos::SetCalcValues(Float_t mag, Float_t x, Float_t y, Float_t sigmaMinorAxis, Float_t sigmaMajorAxis)
{
     fMagCalc = mag;
     fMeanXCalc = x;
     fMeanYCalc = y;
     fSigmaMinorAxisCalc = sigmaMinorAxis;
     fSigmaMajorAxisCalc = sigmaMajorAxis;
}

void MStarLocalPos::SetFitValues(Float_t mag, Float_t x, Float_t y, Float_t sigmaMinorAxis, Float_t sigmaMajorAxis)
{
     fMagFit = mag;
     fMeanXFit = x;
     fMeanYFit = y;
     fSigmaMinorAxisFit = sigmaMinorAxis;
     fSigmaMajorAxisFit = sigmaMajorAxis;
}

void MStarLocalPos::Paint(Option_t *opt)
{}
  
void MStarLocalPos::Print(Option_t *opt) const
{
    *fLog << inf << "Star expected position:" << endl;
    *fLog << inf << " X " << fXExp << " mm \tY " << fYExp << " mm" << endl;
    *fLog << inf << "Star calculated position:" << endl;
    *fLog << inf << " X " << fMeanXCalc << " mm \tY " << fMeanYCalc << " mm" << endl;
    *fLog << inf << "Star fitted position:" << endl;
    *fLog << inf << " X " << fXExp << " mm \tY " << fYExp << " mm" << endl;
}
