#ifndef MARS_MJFindStars
#define MARS_MJFindStars

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

#ifndef ROOT_TArrayC
#include <TArrayC.h>
#endif

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MHCamera
#include "MHCamera.h"
#endif

#ifndef MARS_MAstroCamera
#include "MAstroCamera.h"
#endif

class MGeomCam;
class MGeomPix;
class MCameraDC;
class MTime;
class MReportDrive;
class MStarLocalCam;
class MStarLocalPos;

class MFindStars : public MTask
{

private:

    MGeomCam      *fGeomCam;
    MCameraDC     *fCurr;
    MTime         *fTimeCurr;
    MReportDrive  *fDrive;
    MStarLocalCam *fStars;

    MAstroCamera fAstro;
    TArrayC      fPixelsUsed;
    MHCamera     fDisplay;

    UInt_t fMaxNumIntegratedEvents;
    UInt_t fNumIntegratedEvents;

    Float_t fRingInterest; //[mm]
    Float_t fMinDCForStars;

    Bool_t FindPixelWithMaxDC(Float_t &maxDC, MGeomPix &maxPix);
    Bool_t FindStar(MStarLocalPos* star);
    Bool_t ShadowStar(MStarLocalPos* star);

  public:
    MFindStars(const char *name=NULL, const char *title=NULL);
    
    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();
  
    void SetNumIntegratedEvents(UInt_t max) {fMaxNumIntegratedEvents=max;}
    void SetRingInterest(Float_t ring) {fRingInterest=ring;}
    void SetBlindPixels(TArrayS blindpixels);


  ClassDef(MFindStars, 0) // Tool to find stars from DC Currents
};

#endif
