#ifndef MARS_MCalibrateDC
#define MARS_MCalibrateDC

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef ROOT_TString
#include <TString.h>
#endif

#ifndef MARS_MHCamera
#include "MHCamera.h"
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

#ifndef MARS_MTask
#include "MTask.h"
#endif

class TH1F;
class MGeomCam;
class MCameraDC;

class MCalibrateDC : public MTask
{

private:

    MGeomCam      *fGeomCam;
    MCameraDC     *fCurr;
    MTime         *fTimeCurr;

    MTime fStartingMissCalibration;
    MTime fEndingMissCalibration;
    
    TString fFileName;
    
    TH1F *fCalHist;
    MHCamera fDisplay;

    UInt_t fNumPixels ;
    TArrayF fDCCalibrationFactor;
    Float_t fDCMissCalibrationFactor;
    
    Float_t fDCCalibration; //[uA]
    Float_t fDCCalibrationRMS; //[uA]
    
    Bool_t DCCalibrationCalc();
    
  public:
    
    MCalibrateDC(TString filename="", const char *name=NULL, const char *title=NULL);
    ~MCalibrateDC();

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    //Setters
    void SetFileName(TString filename="") {fFileName=filename;}
    
  ClassDef(MCalibrateDC, 0) // Taks to intercalibrate the DC of all pmts from a continuos light run
};

#endif
