#ifndef MARS_MSrcTranslate
#define MARS_MSrcTranslate

#ifndef MARS_MSrcPlace
#include "MSrcPlace.h"
#endif

class MSrcTranslate : public MSrcPlace
{
 private:
  
  Double_t fShiftX;
  Double_t fShiftY;
  Bool_t   fTranslationIsRelative;
  
  Int_t PreProcess(MParList *plist);

 public:
  MSrcTranslate(const char* src="MSrcPosCam", const char* dca="MDCA",
		const char* name=NULL, const char* title=NULL);
  
  void SetTranslation(Double_t x=0.,Double_t y=0) {fShiftX=x,fShiftY=y;};
  void SetRelativeTranslation(Bool_t inp=kTRUE) {fTranslationIsRelative=inp;};
  virtual Int_t ComputeNewSrcPosition();

  ClassDef(MSrcTranslate, 0) // task to rotate the position of the source as a function of Azimuth and Zenith angles
};

#endif

