/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Author(s): Javier Rico     05/2004 <mailto:jrico@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
// MDisplay
//
//
//
//////////////////////////////////////////////////////////////////////////////

#include <fstream>
#include <math.h>

#include "MParList.h"
#include "MDisplay.h"
#include "MCamEvent.h"
#include "MGeomCam.h"
#include "MHCamera.h"

#include "TCanvas.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MDisplay);

using namespace std;

static const TString gsDefName  = "MDisplay";
static const TString gsDefTitle = "Camera display task";

// -------------------------------------------------------------------------
//
// Constructor.
//
MDisplay::MDisplay(MCamEvent* event, MGeomCam* geom, Int_t type, const char* name, const char* title) 
  :  fGeomCam(geom), fCamEvent(event),  fCanvas(NULL), fDisplayType(type)
{
  fName  = name  ? name  : gsDefName.Data();
  fTitle = title ? title : gsDefTitle.Data();

  fDisplay = new MHCamera(*geom);
  fDisplay->SetPrettyPalette();
}
// -------------------------------------------------------------------------
//
// Destructor
//
MDisplay::~MDisplay()
{
  delete fDisplay;
  if(fCanvas)
    delete fCanvas;
}

// -------------------------------------------------------------------------
//
// Look for needed containers.
//
Int_t MDisplay::PreProcess(MParList* pList)
{ 
  fCanvas = new TCanvas("myCanvas","Event Display",600,600);
  fCanvas->cd(1);
  fDisplay->Draw();

  return kTRUE;
}

// -------------------------------------------------------------------------
//
// Call to compute a new position and then save it in the histogram (fMode==kOn) 
// of to read the new position from the histogram (fMode==kOff)
//
Int_t MDisplay::Process()
{  
  fDisplay->SetCamContent(*fCamEvent);
  fCanvas->GetPad(1)->Modified();
  fCanvas->GetPad(1)->Update();

  // pause execution
  cout << "Type 'q' to exit, <return> to go on: ";      
  TString input;
  input =cin.get(); 
  
  if (input=='q')
    return kFALSE;
  else
    return kTRUE;
}

// -------------------------------------------------------------------------
//
// Dump 2D histo statistics
//
Int_t MDisplay::PostProcess()
{
  return kTRUE;
}
