#ifndef MARS_MDisplay
#define MARS_MDisplay

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHCamera;
class MCamEvent;
class MGeomCam;
class TCanvas;

class MDisplay : public MTask
{
 private:
  MHCamera*  fDisplay;     // pointer to the camera display
  MGeomCam*  fGeomCam;     // pointer to the camera geometry
  MCamEvent* fCamEvent;    // pointer to camera event
  TCanvas*   fCanvas;      // pointer to the canvas
  Int_t      fDisplayType; 
  
  virtual Int_t PostProcess();

 protected:
  virtual Int_t PreProcess(MParList *plist);  
  virtual Int_t Process();

 public:
  MDisplay(MCamEvent* event, MGeomCam* geom, Int_t type=0, const char* name=NULL, const char* title=NULL);
  virtual ~MDisplay();

  MGeomCam*    GetGeomCam()               {return fGeomCam;}
  void         SetDisplayType(Int_t type) {fDisplayType=type;}
  virtual void Paint(Option_t* option)    {};

  ClassDef(MDisplay, 0) // Task to display camera containers
};

#endif

