/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier López , 7/2004 <mailto:jlopez@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

#include "MLiveTime.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MLiveTime);

using namespace std;

MLiveTime::MLiveTime(UInt_t numberbins, const char *name, const char *title)
{

    fName  = name  ? name  : "MLiveTime";
    fTitle = title ? title : "Container to hold the live time for a certain time bin";
    
    Set(numberbins);
}

void MLiveTime::Set(UInt_t numberbins)
{
  fNumberTimeBins = numberbins;
  fLiveTimeBin.Set(numberbins);
  fMeanRealTimeBin.Set(numberbins);
  fWidthRealTimeBin.Set(numberbins);
}

void MLiveTime::Print(const Option_t* o) const
{
    TString opt = o;

    Double_t totalLiveTime = 0;

    if (opt.Contains("last", TString::kIgnoreCase))
    {
	*fLog << GetName() << ": Present real time bin " << setprecision(10) << fMeanRealTimeBin[fNumberTimeBins-1] << " +- " << setprecision(5) << fWidthRealTimeBin[fNumberTimeBins-1] << " [" <<  2*fWidthRealTimeBin[fNumberTimeBins-1]*24*60*60 << " sec] MJD" << endl;
	*fLog << GetName() << ": Present live time " << fLiveTimeBin[fNumberTimeBins-1] << " sec" << endl;
    }
    else if (opt.Contains("all", TString::kIgnoreCase))
    {
	*fLog << GetName() << ": " << fNumberTimeBins << " time bins" << endl;
	for (UInt_t bin = 0; bin<fNumberTimeBins; bin++)
	{
	    *fLog << GetName() << ": Present real time bin " << setprecision(10) << fMeanRealTimeBin[bin] << " +- " << setprecision(5) <<  fWidthRealTimeBin[bin] << " [" <<  2*fWidthRealTimeBin[bin]*24*60*60 << " sec] MJD" << endl;
	    *fLog << GetName() << ": Present live time " << fLiveTimeBin[bin] << " sec" << endl;
	    totalLiveTime += fLiveTimeBin[bin];
	}		
	*fLog << GetName() << ": Total live time " << totalLiveTime << endl;
    }
    else
	*fLog << GetName() << warn << "::Print() Bad argument " << opt << endl; 
}
