#ifndef MARS_MIslands
#define MARS_MIslands

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class MIslands : public MParContainer
{
private:
    // for description see MIslands.cc
    Int_t fIslNum;             //  number of islands
    //    Int_t** fIslId;      //[fIslNum]  island Id
    // TObjArray fIslId;       //  island Id
    Int_t fIslId[577];         //island Id
    Int_t* fPixNum;            //[fIslNum]  number of pixels in the island
    Float_t* fSigToNoise;      //[fIslNum]  signal to noise of the island
    //  Float_t** fTime;       //[fIslNum]  mean of the arrival time
    // Float_t fTime[10][577];        //  mean of the arrival time
    Float_t* fTimeSpread;      //[fIslNum]  mean arrival time spread of the core pixels of the island  
    Float_t* fMeanX;           //[fIslNum]  mean X position of the island
    Float_t* fMeanY;           //[fIslNum]  mean Y position of the island
    Float_t* fDist;            //[fIslNum]  dist between islands and continent(larger island)
    Float_t fLength;           //  major axis of the larger island ellipse
    Float_t fWidth;            //  minor axis of the larger island ellipse
    Float_t* fDistL;           //[fIslNum] Dist of the island divided by Length of the larger island
    Float_t* fDistW;           //[fIslNum] Dist of the island divided by Width of the larger island
    
public:
    MIslands(const char *name=NULL, const char *title=NULL);
    ~MIslands();

    // void Clear();
    void Print(Option_t *opt=NULL) const;
    
    //getter methods
    Int_t    GetIslNum() const               { return fIslNum; }
    Int_t    GetIslId(Int_t idx)  { return fIslId[idx]; }
    //Int_t    GetIslId(Int_t isl, Int_t idx)  { return fIslId[isl][idx]; }
    // TObjArray GetIslId()                    {return fIslId;}
    //  Float_t  GetArrivalTime(Int_t isl, Int_t idx) { return fTime[isl][idx]; }     
    //TObjArray GetArrivalTime()               { return fTime; }     
    Int_t    GetPixNum(Int_t isl)            { return fPixNum[isl]; }
    Float_t  GetSigToNoise(Int_t isl)        { return fSigToNoise[isl]; }      
    Float_t  GetTimeSpread(Int_t isl)        { return fTimeSpread[isl];}          
    Float_t  GetMeanX(Int_t isl)             { return fMeanX[isl];}
    Float_t  GetMeanY(Int_t isl)             { return fMeanY[isl];}
    Float_t  GetDist(Int_t isl)              { return fDist[isl]; }
    Float_t  GetDistL(Int_t isl)             { return fDistL[isl]; }
    Float_t  GetDistW(Int_t isl)             { return fDistW[isl]; }
    
    Float_t  GetLength() const               { return fLength; }
    Float_t  GetWidth() const                { return fWidth; }

    //setter functions    
    void     SetIslNum(Int_t nisl)           { fIslNum = nisl; }
    void     SetIslId(Int_t idx, Int_t isl)           { fIslId[idx] = isl; }
    
    // void     SetIslId(Int_t** vect)           { fIslId = vect; }
    // void     SetArrivalTime(Int_t isl, Int_t idx, Float_t val)   { fTime[isl][idx] = val;}
    //  void     SetArrivalTime(Float_t** vect)   { fTime = vect;}
    void     SetPixNum(Int_t* npix)          { fPixNum = npix; }
    void     SetSigToNoise(Float_t* val)     { fSigToNoise = val; }
    void     SetTimeSpread(Float_t* val)     { fTimeSpread = val; }
    void     SetMeanX( Float_t* val)         { fMeanX = val; }
    void     SetMeanY(Float_t* val)          { fMeanY = val; }
    void     SetDist(Float_t* val)           { fDist = val; }
    void     SetDistL(Float_t* val)          { fDistL=val; }
    void     SetDistW(Float_t* val)          { fDistW=val; }

    void     SetLength(Float_t val)          { fLength=val; }
    void     SetWidth(Float_t val)           { fWidth=val; }

   
    

    ClassDef(MIslands, 2) // Storage Container for Island Parameters
};

#endif
