/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cherenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Author(s): Daniel Mazin, 05/2004 <mailto:mazin@imppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

// Daniel Mazin 14.05.2004  mazin@mppmu.mpg.de
//**********************************************************
// this macro is a short form of the macro ONOFFAnalysis.C
// three jobs are executed:
// 1)  image cleaning
// 2)  calculation of hillas parameters
// 3)  writing the root file
//**********************************************************

gROOT->Reset();

//************************************************************************
void cleaninghillas(const char *onfile, 
                    const char *offfile, 
                    TString typeInput, 
                    TString inPath, 
                    TString outPath,
                    TString sourcename) 
{

    TString fileON  = inPath;
    fileON += onfile;
    fileON += ".root";

    TString fileOFF = inPath;
    fileOFF += offfile;
    fileOFF += ".root";

    // name of input root file
    if (typeInput == "ON")
      TString filenamein(fileON);
    else if (typeInput == "OFF")
      TString filenamein(fileOFF);

    // name of output root file
    if (typeInput == "ON")
      TString file(onfile);
    else if (typeInput == "OFF")
      TString file(offfile);

    TString outNameImage = outPath;
    outNameImage += sourcename;
    outNameImage += "Hillas";
    outNameImage += typeInput;
    outNameImage += ".root";


    //  set up the task list:
    //-----------------------------------------------------------
    MTaskList tliston;
    MParList pliston;

    MObservatory observ;
    pliston.AddToList(&observ);

    MPointingPos mpos;
    pliston.AddToList(&mpos);

    MMcEvt mmc;
    pliston.AddToList(&mmc);

    char *sourceName = "MSrcPosCam";
    MSrcPosCam source(sourceName);

    // geometry is needed in  MHHillas... classes 
    MGeomCam *fGeom = 
             (MGeomCam*)pliston->FindCreateObj("MGeomCamMagic", "MGeomCam");

    //-------------------------------------------
    // create the tasks which should be executed 
    //

    MReadMarsFile read("Events", filenamein);
    read.DisableAutoScheme();

    MGeomApply        apply;

 // NOTE: MMcEvt is used temporary. MPointingPos should be used as soon as synchronisation is working
 //
 // the following task is used to fill in a MMcEvt container with Theta and Phi values 
 // for each event using an ascii file (which is generated from central control report file) 
 // PLEASE NOTE: only needed if a derotation around the center of the camera is planned 
 // to be performed afterwords
    MSourcePosfromStarPos sourcefromstar;

    if (typeInput == "ON")
    {
	    sourcefromstar.AddFile("~mazin/mars/MarsCVS/Mars/positionsON", 0);
    }
    else if (typeInput == "OFF")
    {
        sourcefromstar.AddFile("~mazin/mars/MarsCVS/Mars/positionsOFF", 0);
    }



// -----------------------------------------------------
// image cleaning  -------------------------------------
// -----------------------------------------------------    
    MSigmabarCalc sigbar;

    MBlindPixelsCalc2 blind;
    blind.SetUseInterpolation();
    blind.SetCheckPedestalRms();
    blind.SetName("BlindAfterPadding");

    MFSelBasic selbasic;
    MContinue contbasic(&selbasic);
    contbasic.SetName("SelBasic");

//    MImgCleanStd    clean(3.0, 2.5);  // Crab 27th old calibr (Hendrik)
    MImgCleanStd    clean(4.0, 3.0);
//    clean.SetMethod(MImgCleanStd::kDemocratic);
    clean.SetCleanRings(1); 


// -----------------------------------------------------
// calculation of  image parameters ---------------------
// -----------------------------------------------------    
    TString fHilName    = "MHillas";
    TString fHilNameExt = "MHillasExt";
    TString fHilNameSrc = "MHillasSrc";
    TString fImgParName = "MNewImagePar";

    MHillasCalc    hcalc;
    hcalc.SetNameHillas(fHilName);
    hcalc.SetNameHillasExt(fHilNameExt);
    hcalc.SetNameNewImgPar(fImgParName);

    MHillasSrcCalc hsrccalc(sourceName, fHilNameSrc);
    hsrccalc.SetInput(fHilName);

    MFSelStandard selstandard(fHilNameSrc);
    selstandard.SetHillasName(fHilName);
    selstandard.SetImgParName(fImgParName);
//    selstandard.SetCuts(usedpixelsmax, corepixelsmin, sizemin, distmin, distmax, lengthmin, widthmin);
    selstandard.SetCuts(200, 5, 200, 0.0, 5.0, 0.07, 0.05);
    MContinue contstandard(&selstandard);
    contstandard.SetName("SelStandard");

// -----------------------------------------------------
// write root file
// -----------------------------------------------------    
      MWriteRootFile write(outNameImage);

      write.AddContainer("MRawRunHeader", "RunHeaders");
      //write.AddContainer("MTime",         "Events");
      write.AddContainer("MPointingPos",   "Events");
      //write.AddContainer("ThetaOrig",     "Events");
      write.AddContainer("MSrcPosCam",    "Events");
      write.AddContainer("MSigmabar",     "Events");
      write.AddContainer("MHillas",       "Events");
      write.AddContainer("MHillasExt",    "Events");
      write.AddContainer("MHillasSrc",    "Events");
      write.AddContainer("MNewImagePar",  "Events");
    

    //*****************************
    // entries in MParList
    
    pliston.AddToList(&tliston);
    pliston.AddToList(&observ);

    pliston.AddToList(&source);

    //*****************************
    // entries in MTaskList
    

    tliston.AddToList(&read);
    tliston.AddToList(&apply);
    tliston.AddToList(&sourcefromstar);


    tliston.AddToList(&sigbar);
    tliston.AddToList(&blind);
    tliston.AddToList(&contbasic);

    tliston.AddToList(&clean);

    tliston.AddToList(&hcalc);
    tliston.AddToList(&hsrccalc);
    tliston.AddToList(&contstandard);
    tliston.AddToList(&write);

    //*****************************

    //-------------------------------------------
    // Execute event loop
    //
    MProgressBar bar;
    MEvtLoop evtloop;
    evtloop.SetParList(&pliston);
    //evtloop.ReadEnv(env, "", printEnv);
    evtloop.SetProgressBar(&bar);
    //  evtloop.Write();

    Int_t maxevents = -1;
    //Int_t maxevents = 1000;
    if ( !evtloop.Eventloop(maxevents) )
        return;

    tliston.PrintStatistics(0, kTRUE);


}



