#ifndef MARS_MVPPlotter
#define MARS_MVPPlotter

#ifndef MARS_MTaskList
#include "MTaskList.h"
#endif

#ifndef MARS_MVPObject
#include "MVPObject.h"
#endif

#ifndef MARS_MVPTime
#include "MVPTime.h"
#endif

#ifndef MARS_MObservatoryLocation
#include "MObservatoryLocation.h"
#endif

class TH1D;
class TH2D;
class TCanvas;

class MVPPlotter
{
private:

  MVPTime   *fTime;
  MObservatoryLocation *fObs;

  MParList fPlist;
  MTaskList fTlist;

  Bool_t fUseSun;
  Bool_t fUseMoon;
  Bool_t fUsePlanets;

  Double_t fAstronomicalDarkness;

  Int_t fgSecPerDay;
  Int_t fgMJD010170; // 01-01-70 is JD 40586
  Double_t fgDegToRad;

  TH2D *fMjdUtcYear;
  TH2D *fMjdUtcYearMoon;
  TH1D *fMjdMoonPhase;
  TH1D *fMjdMoonDistance;
  TH1D *fMjdPlanetDistance;
  TH1D *fMjdMoonIntensity;
  TH1D *fMjdObsHours;

  MVPObject *fObject;
  MVPObject *fSun;
  MVPObject *fMoon;
  MVPObject *fVenus;
  MVPObject *fMars;
  MVPObject *fJupiter;
  MVPObject *fSaturn;

  void SetupObjects();

public:
    MVPPlotter(const char *name=NULL, const char *title=NULL);
    ~MVPPlotter();

    void SetObject(MVPObject *o) { fObject=o; }
    void SetObservatory(MObservatoryLocation *l) { fObs=l; }
    void SetAstronomicalDarkness(Double_t d) { fAstronomicalDarkness=d; }

    Double_t LunSkyBright(Double_t moon_phase,Double_t rho,Double_t altmoon,Double_t alt);
    Bool_t CalcYear(Int_t year, UInt_t daySlices);

    ClassDef(MVPPlotter, 2) // Visibility Plotter: The Plotter Routine itself
}; 

#endif

