#ifndef MARS_MExtrapolatePointingPos
#define MARS_MExtrapolatePointingPos

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef ROOT_TSpline
#include <TSpline.h>
#endif

#ifndef ROOT_TString
#include <TString.h>
#endif


class MTime;
class MPointingPos;
class MRawRunHeader;
class TString;

class MExtrapolatePointingPos : public MTask
{

 private:

    TString fFilename;

    MTime  *fEvtTime;            // raw event time
    MPointingPos *fPointingPos;  // telescope pointing postion
    MRawRunHeader* fRunHeader;

    TSpline3* fSplineZd;  // Zd vs. time
    TSpline3* fSplineAz;  // Az vs. time
    TSpline3* fSplineRa;  // Ra vs. time
    TSpline3* fSplineDec; // Dec vs. time

   
    Int_t PreProcess(MParList *pList);
    Int_t Process();
    


 public:
    
    MExtrapolatePointingPos(const TString reportname, const char *name=NULL, const char *title=NULL);

    ~MExtrapolatePointingPos();

    void ReadDriveReport(const TString filename);
  

    ClassDef(MExtrapolatePointingPos, 1)  
};

#endif




