#ifndef MARS_MHTelAxisFromStars
#define MARS_MHTelAxisFromStars

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1D;
class TH2D;
class MTelAxisFromStars;
class MSrcPosCam;
class MSkyCamTrans;
class MStarLocalCam;

class MHTelAxisFromStars : public MH
{
private:

    TH1D *fNStars;     //-> Number of stars
    TH1D *fNdoF;       //-> Number of degrees of freedom
    TH1D *fChi2Prob;   //-> Chi2 probability
    TH1D *fNumIter;    //-> Number of iterations
    TH1D *fLambda;     //-> Scale factor lambda
    TH1D *fAlfa;       //-> Rotation angle alfa

    TH2D *fShift;      //-> Shift between Sky and Camera system
    TH2D *fEstPos1;    //-> Estimated position 1
    TH2D *fEstPos2;    //-> Estimated position 2

    MStarLocalCam   *fStarLocalCam;     //!
    MStarLocalCam   *fSourceLocalCam;   //!
    MSrcPosCam      *fSrcPos;           //!
    MSkyCamTrans    *fSkyCamTrans;      //!



    Float_t fMm2Deg;                    //!
    Bool_t  fUseMmScale;                //!
    Int_t   fInputType;                 //!

    void SetColors() const;
    void Paint(Option_t *opt="");

public:
    MHTelAxisFromStars(const char *name=NULL, const char *title=NULL);
    ~MHTelAxisFromStars();

    void SetInputType(Int_t type=2);
    void SetMmScale(Bool_t mmscale=kTRUE);
    virtual void SetMm2Deg(Float_t mmdeg);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    TH1 *GetHistByName(const TString name);

    TH1D *GetHistNStars()    { return fNStars;    }
    TH1D *GetHistNdoF()      { return fNdoF;      }
    TH1D *GetHistChi2Prob()  { return fChi2Prob;  }

    TH1D *GetHistNumIter()   { return fNumIter;   }
    TH1D *GetHistLambda()    { return fLambda;    } 

    TH1D *GetHistAlfa()      { return fAlfa;      }

    TH2D *GetHistShift()     { return fShift;     }
    TH2D *GetHistEstPos1()   { return fEstPos1;   }
    TH2D *GetHistEstPos2()   { return fEstPos2;   }

    void Draw(Option_t *opt=NULL);

    ClassDef(MHTelAxisFromStars, 1) // Container which holds histograms for MTelAxisFromStars
};

#endif





