#ifndef MARS_MLiveTimeCalc
#define MARS_MLiveTimeCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MRawRunHeader;
class MRawEvtHeader;
class MLiveTime;

class MLiveTimeCalc : public MTask
{
 public:
  
  const Double_t kSecTomSec;
  const Double_t kDayToSec;
  
 private:
  
  MRawRunHeader* fRunHeader;
  MRawEvtHeader* fEvtHeader;

  MTime*         fPresentEventTime;
  MTime          fLastEventTime;
  MTime          fPreaviusLastEventTime;

  MLiveTime*     fLiveTime;

  
  UInt_t   fNumberLostEvents[10];

  Double_t fFirstEventMjd;
  Double_t fPresentEventMjd;
  Double_t fLastEventMjd;
  Double_t fPreaviusLastEventMjd;

  Int_t    fPresentEventNumber;
  Int_t    fLastEventNumber;
  Double_t fPreaviusLastEventNumber;

  Int_t    fPresentEventRunNumber;
  Int_t    fLastEventRunNumber;
  Double_t fPreaviusLastEventRunNumber;

  Double_t fRealTimeBinSize;
  
  Bool_t fPrintNextEvent;

 public:

  MLiveTimeCalc(const char *name=NULL, const char *title=NULL);
  //~MLiveTimeCalc;

  Int_t PreProcess(MParList *pList);
  Int_t Process();
  Int_t PostProcess();

  void SetRealTimeBinSize(Double_t time) { fRealTimeBinSize=time; }

  Bool_t isTimeStampOk();
  void Print(const Option_t *o) const;

 ClassDef(MLiveTimeCalc, 0)    // Task to compute the live time from real data
};

#endif
