void plotnoise()
{
  // Simple macro to read calibrated pedestal files, from MC and real data, and compare 
  // fluctuations

  gStyle->SetOptStat(kFALSE);

  TChain mc("Events");
  TChain data("Events");

  // Input files: MC and data files containing calibrated pedestal data, in the form 
  // of MCerPhotEvt containers (as produced by mccalibrate.C)

  mc.Add("/data1/MAGIC/Period016/mcdata/noise/root/electronic_noise.root");
  data.Add("/data1/MAGIC/Period014/rootdata/2004_03_03/calibrated_20122.root");

  // Warning! Binnings have to be set somehow manually to get 
  // nice display... (due to rounding problems...)

  TH1F* hinnermc = new TH1F("hinnermc","Noise inner",1001, -200.5, 200.5);
  TH1F* hinnerdata = new TH1F("hinnerdata","Noise inner",500, -200.5, 200.5);

  TH1F* houtermc = new TH1F("houtermc","Noise outer",601, -300.5, 300.5);
  TH1F* houterdata = new TH1F("houterdata","Noise outer",100, -300.5, 300.5);

  hinnermc->Sumw2();
  hinnerdata->Sumw2();
  houtermc->Sumw2();
  houterdata->Sumw2();

  // The normalizations of y axis (multiplicative factors in 3rd argument of Project) 
  // are for now introduced manually:

  mc.Project("hinnermc", "MCerPhotEvt.fPixels.fPhot", "0.77*(MCerPhotEvt.fPixels.fPixId<397 && MCerPhotEvt.fPixels.fPixId>0 )");

  data.Project("hinnerdata", "MCerPhotEvt.fPixels.fPhot", "(MCerPhotEvt.fPixels.fPixId<397 && MCerPhotEvt.fPixels.fPixId>0 )");


  // Same for outer pixels:
  //  mc.Project("houtermc", "MCerPhotEvt.fPixels.fPhot", "1.26*(MCerPhotEvt.fPixels.fPixId>=397)");
  //    data.Project("houterdata", "MCerPhotEvt.fPixels.fPhot", "(MCerPhotEvt.fPixels.fPixId>=397)");

  hinnerdata->DrawCopy("e");
  hinnermc->SetLineColor(2);
  hinnermc->SetMarkerColor(2);
  hinnermc->DrawCopy("e,same");

  //     houterdata->DrawCopy("e");
  //     houtermc->SetLineColor(2);
  //     houtermc->SetMarkerColor(2);
  //     houtermc->DrawCopy("e,same");


  return;
}
